package me.snowdrop.istio.api.networking.v1alpha3;

import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.builder.Predicate;
import java.util.LinkedHashMap;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.List;
import java.lang.Boolean;
import java.lang.Integer;
import javax.validation.Valid;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

public class HTTPMatchRequestFluentImpl<A extends HTTPMatchRequestFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements HTTPMatchRequestFluent<A>{

    private StringMatchBuilder authority;
    private List<String> gateways;
    private Map<String,StringMatch> headers;
    private StringMatchBuilder method;
    private Integer port;
    private StringMatchBuilder scheme;
    private Map<String,String> sourceLabels;
    private StringMatchBuilder uri;

    public HTTPMatchRequestFluentImpl(){
    }
    public HTTPMatchRequestFluentImpl(HTTPMatchRequest instance){
            this.withAuthority(instance.getAuthority()); 
            this.withGateways(instance.getGateways()); 
            this.withHeaders(instance.getHeaders()); 
            this.withMethod(instance.getMethod()); 
            this.withPort(instance.getPort()); 
            this.withScheme(instance.getScheme()); 
            this.withSourceLabels(instance.getSourceLabels()); 
            this.withUri(instance.getUri()); 
    }

    
/**
 * This method has been deprecated, please use method buildAuthority instead.
 * @return The buildable object.
 */
@Deprecated public StringMatch getAuthority(){
            return this.authority!=null?this.authority.build():null;
    }

    public StringMatch buildAuthority(){
            return this.authority!=null?this.authority.build():null;
    }

    public A withAuthority(StringMatch authority){
            _visitables.remove(this.authority);
            if (authority!=null){ this.authority= new StringMatchBuilder(authority); _visitables.add(this.authority);} return (A) this;
    }

    public Boolean hasAuthority(){
            return this.authority != null;
    }

    public HTTPMatchRequestFluent.AuthorityNested<A> withNewAuthority(){
            return new AuthorityNestedImpl();
    }

    public HTTPMatchRequestFluent.AuthorityNested<A> withNewAuthorityLike(StringMatch item){
            return new AuthorityNestedImpl(item);
    }

    public HTTPMatchRequestFluent.AuthorityNested<A> editAuthority(){
            return withNewAuthorityLike(getAuthority());
    }

    public HTTPMatchRequestFluent.AuthorityNested<A> editOrNewAuthority(){
            return withNewAuthorityLike(getAuthority() != null ? getAuthority(): new StringMatchBuilder().build());
    }

    public HTTPMatchRequestFluent.AuthorityNested<A> editOrNewAuthorityLike(StringMatch item){
            return withNewAuthorityLike(getAuthority() != null ? getAuthority(): item);
    }

    public A addToGateways(int index,String item){
            if (this.gateways == null) {this.gateways = new ArrayList<String>();}
            this.gateways.add(index, item);
            return (A)this;
    }

    public A setToGateways(int index,String item){
            if (this.gateways == null) {this.gateways = new ArrayList<String>();}
            this.gateways.set(index, item); return (A)this;
    }

    public A addToGateways(String... items){
            if (this.gateways == null) {this.gateways = new ArrayList<String>();}
            for (String item : items) {this.gateways.add(item);} return (A)this;
    }

    public A addAllToGateways(Collection<String> items){
            if (this.gateways == null) {this.gateways = new ArrayList<String>();}
            for (String item : items) {this.gateways.add(item);} return (A)this;
    }

    public A removeFromGateways(String... items){
            for (String item : items) {if (this.gateways!= null){ this.gateways.remove(item);}} return (A)this;
    }

    public A removeAllFromGateways(Collection<String> items){
            for (String item : items) {if (this.gateways!= null){ this.gateways.remove(item);}} return (A)this;
    }

    public List<String> getGateways(){
            return this.gateways;
    }

    public String getGateway(int index){
            return this.gateways.get(index);
    }

    public String getFirstGateway(){
            return this.gateways.get(0);
    }

    public String getLastGateway(){
            return this.gateways.get(gateways.size() - 1);
    }

    public String getMatchingGateway(io.fabric8.kubernetes.api.builder.Predicate<String> predicate){
            for (String item: gateways) { if(predicate.apply(item)){return item;} } return null;
    }

    public A withGateways(List<String> gateways){
            if (this.gateways != null) { _visitables.removeAll(this.gateways);}
            if (gateways != null) {this.gateways = new ArrayList<String>(); for (String item : gateways){this.addToGateways(item);}} else { this.gateways = null;} return (A) this;
    }

    public A withGateways(String... gateways){
            if (this.gateways != null) {this.gateways.clear();}
            if (gateways != null) {for (String item :gateways){ this.addToGateways(item);}} return (A) this;
    }

    public Boolean hasGateways(){
            return gateways != null && !gateways.isEmpty();
    }

    public A addToHeaders(String key,StringMatch value){
            if(this.headers == null && key != null && value != null) { this.headers = new LinkedHashMap<String,StringMatch>(); }
            if(key != null && value != null) {this.headers.put(key, value);} return (A)this;
    }

    public A addToHeaders(Map<String,StringMatch> map){
            if(this.headers == null && map != null) { this.headers = new LinkedHashMap<String,StringMatch>(); }
            if(map != null) { this.headers.putAll(map);} return (A)this;
    }

    public A removeFromHeaders(String key){
            if(this.headers == null) { return (A) this; }
            if(key != null && this.headers != null) {this.headers.remove(key);} return (A)this;
    }

    public A removeFromHeaders(Map<String,StringMatch> map){
            if(this.headers == null) { return (A) this; }
            if(map != null) { for(Object key : map.keySet()) {if (this.headers != null){this.headers.remove(key);}}} return (A)this;
    }

    public Map<String,StringMatch> getHeaders(){
            return this.headers;
    }

    public A withHeaders(Map<String,StringMatch> headers){
            if (headers == null) { this.headers =  null;} else {this.headers = new LinkedHashMap<String,StringMatch>(headers);} return (A) this;
    }

    public Boolean hasHeaders(){
            return this.headers != null;
    }

    
/**
 * This method has been deprecated, please use method buildMethod instead.
 * @return The buildable object.
 */
@Deprecated public StringMatch getMethod(){
            return this.method!=null?this.method.build():null;
    }

    public StringMatch buildMethod(){
            return this.method!=null?this.method.build():null;
    }

    public A withMethod(StringMatch method){
            _visitables.remove(this.method);
            if (method!=null){ this.method= new StringMatchBuilder(method); _visitables.add(this.method);} return (A) this;
    }

    public Boolean hasMethod(){
            return this.method != null;
    }

    public HTTPMatchRequestFluent.MethodNested<A> withNewMethod(){
            return new MethodNestedImpl();
    }

    public HTTPMatchRequestFluent.MethodNested<A> withNewMethodLike(StringMatch item){
            return new MethodNestedImpl(item);
    }

    public HTTPMatchRequestFluent.MethodNested<A> editMethod(){
            return withNewMethodLike(getMethod());
    }

    public HTTPMatchRequestFluent.MethodNested<A> editOrNewMethod(){
            return withNewMethodLike(getMethod() != null ? getMethod(): new StringMatchBuilder().build());
    }

    public HTTPMatchRequestFluent.MethodNested<A> editOrNewMethodLike(StringMatch item){
            return withNewMethodLike(getMethod() != null ? getMethod(): item);
    }

    public Integer getPort(){
            return this.port;
    }

    public A withPort(Integer port){
            this.port=port; return (A) this;
    }

    public Boolean hasPort(){
            return this.port != null;
    }

    public A withNewPort(String arg1){
            return (A)withPort(new Integer(arg1));
    }

    public A withNewPort(int arg1){
            return (A)withPort(new Integer(arg1));
    }

    
/**
 * This method has been deprecated, please use method buildScheme instead.
 * @return The buildable object.
 */
@Deprecated public StringMatch getScheme(){
            return this.scheme!=null?this.scheme.build():null;
    }

    public StringMatch buildScheme(){
            return this.scheme!=null?this.scheme.build():null;
    }

    public A withScheme(StringMatch scheme){
            _visitables.remove(this.scheme);
            if (scheme!=null){ this.scheme= new StringMatchBuilder(scheme); _visitables.add(this.scheme);} return (A) this;
    }

    public Boolean hasScheme(){
            return this.scheme != null;
    }

    public HTTPMatchRequestFluent.SchemeNested<A> withNewScheme(){
            return new SchemeNestedImpl();
    }

    public HTTPMatchRequestFluent.SchemeNested<A> withNewSchemeLike(StringMatch item){
            return new SchemeNestedImpl(item);
    }

    public HTTPMatchRequestFluent.SchemeNested<A> editScheme(){
            return withNewSchemeLike(getScheme());
    }

    public HTTPMatchRequestFluent.SchemeNested<A> editOrNewScheme(){
            return withNewSchemeLike(getScheme() != null ? getScheme(): new StringMatchBuilder().build());
    }

    public HTTPMatchRequestFluent.SchemeNested<A> editOrNewSchemeLike(StringMatch item){
            return withNewSchemeLike(getScheme() != null ? getScheme(): item);
    }

    public A addToSourceLabels(String key,String value){
            if(this.sourceLabels == null && key != null && value != null) { this.sourceLabels = new LinkedHashMap<String,String>(); }
            if(key != null && value != null) {this.sourceLabels.put(key, value);} return (A)this;
    }

    public A addToSourceLabels(Map<String,String> map){
            if(this.sourceLabels == null && map != null) { this.sourceLabels = new LinkedHashMap<String,String>(); }
            if(map != null) { this.sourceLabels.putAll(map);} return (A)this;
    }

    public A removeFromSourceLabels(String key){
            if(this.sourceLabels == null) { return (A) this; }
            if(key != null && this.sourceLabels != null) {this.sourceLabels.remove(key);} return (A)this;
    }

    public A removeFromSourceLabels(Map<String,String> map){
            if(this.sourceLabels == null) { return (A) this; }
            if(map != null) { for(Object key : map.keySet()) {if (this.sourceLabels != null){this.sourceLabels.remove(key);}}} return (A)this;
    }

    public Map<String,String> getSourceLabels(){
            return this.sourceLabels;
    }

    public A withSourceLabels(Map<String,String> sourceLabels){
            if (sourceLabels == null) { this.sourceLabels =  null;} else {this.sourceLabels = new LinkedHashMap<String,String>(sourceLabels);} return (A) this;
    }

    public Boolean hasSourceLabels(){
            return this.sourceLabels != null;
    }

    
/**
 * This method has been deprecated, please use method buildUri instead.
 * @return The buildable object.
 */
@Deprecated public StringMatch getUri(){
            return this.uri!=null?this.uri.build():null;
    }

    public StringMatch buildUri(){
            return this.uri!=null?this.uri.build():null;
    }

    public A withUri(StringMatch uri){
            _visitables.remove(this.uri);
            if (uri!=null){ this.uri= new StringMatchBuilder(uri); _visitables.add(this.uri);} return (A) this;
    }

    public Boolean hasUri(){
            return this.uri != null;
    }

    public HTTPMatchRequestFluent.UriNested<A> withNewUri(){
            return new UriNestedImpl();
    }

    public HTTPMatchRequestFluent.UriNested<A> withNewUriLike(StringMatch item){
            return new UriNestedImpl(item);
    }

    public HTTPMatchRequestFluent.UriNested<A> editUri(){
            return withNewUriLike(getUri());
    }

    public HTTPMatchRequestFluent.UriNested<A> editOrNewUri(){
            return withNewUriLike(getUri() != null ? getUri(): new StringMatchBuilder().build());
    }

    public HTTPMatchRequestFluent.UriNested<A> editOrNewUriLike(StringMatch item){
            return withNewUriLike(getUri() != null ? getUri(): item);
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            HTTPMatchRequestFluentImpl that = (HTTPMatchRequestFluentImpl) o;
            if (authority != null ? !authority.equals(that.authority) :that.authority != null) return false;
            if (gateways != null ? !gateways.equals(that.gateways) :that.gateways != null) return false;
            if (headers != null ? !headers.equals(that.headers) :that.headers != null) return false;
            if (method != null ? !method.equals(that.method) :that.method != null) return false;
            if (port != null ? !port.equals(that.port) :that.port != null) return false;
            if (scheme != null ? !scheme.equals(that.scheme) :that.scheme != null) return false;
            if (sourceLabels != null ? !sourceLabels.equals(that.sourceLabels) :that.sourceLabels != null) return false;
            if (uri != null ? !uri.equals(that.uri) :that.uri != null) return false;
            return true;
    }


    public class AuthorityNestedImpl<N> extends StringMatchFluentImpl<HTTPMatchRequestFluent.AuthorityNested<N>> implements HTTPMatchRequestFluent.AuthorityNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final StringMatchBuilder builder;
    
            AuthorityNestedImpl(StringMatch item){
                    this.builder = new StringMatchBuilder(this, item);
            }
            AuthorityNestedImpl(){
                    this.builder = new StringMatchBuilder(this);
            }
    
    public N and(){
            return (N) HTTPMatchRequestFluentImpl.this.withAuthority(builder.build());
    }
    public N endAuthority(){
            return and();
    }

}
    public class MethodNestedImpl<N> extends StringMatchFluentImpl<HTTPMatchRequestFluent.MethodNested<N>> implements HTTPMatchRequestFluent.MethodNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final StringMatchBuilder builder;
    
            MethodNestedImpl(StringMatch item){
                    this.builder = new StringMatchBuilder(this, item);
            }
            MethodNestedImpl(){
                    this.builder = new StringMatchBuilder(this);
            }
    
    public N and(){
            return (N) HTTPMatchRequestFluentImpl.this.withMethod(builder.build());
    }
    public N endMethod(){
            return and();
    }

}
    public class SchemeNestedImpl<N> extends StringMatchFluentImpl<HTTPMatchRequestFluent.SchemeNested<N>> implements HTTPMatchRequestFluent.SchemeNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final StringMatchBuilder builder;
    
            SchemeNestedImpl(StringMatch item){
                    this.builder = new StringMatchBuilder(this, item);
            }
            SchemeNestedImpl(){
                    this.builder = new StringMatchBuilder(this);
            }
    
    public N and(){
            return (N) HTTPMatchRequestFluentImpl.this.withScheme(builder.build());
    }
    public N endScheme(){
            return and();
    }

}
    public class UriNestedImpl<N> extends StringMatchFluentImpl<HTTPMatchRequestFluent.UriNested<N>> implements HTTPMatchRequestFluent.UriNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final StringMatchBuilder builder;
    
            UriNestedImpl(StringMatch item){
                    this.builder = new StringMatchBuilder(this, item);
            }
            UriNestedImpl(){
                    this.builder = new StringMatchBuilder(this);
            }
    
    public N and(){
            return (N) HTTPMatchRequestFluentImpl.this.withUri(builder.build());
    }
    public N endUri(){
            return and();
    }

}


}
