package me.snowdrop.istio.api.networking.v1alpha3;

import java.lang.Integer;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.String;
import java.lang.Boolean;

public class HTTPSettingsFluentImpl<A extends HTTPSettingsFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements HTTPSettingsFluent<A>{

    private Integer http1MaxPendingRequests;
    private Integer http2MaxRequests;
    private Integer maxRequestsPerConnection;
    private Integer maxRetries;

    public HTTPSettingsFluentImpl(){
    }
    public HTTPSettingsFluentImpl(HTTPSettings instance){
            this.withHttp1MaxPendingRequests(instance.getHttp1MaxPendingRequests()); 
            this.withHttp2MaxRequests(instance.getHttp2MaxRequests()); 
            this.withMaxRequestsPerConnection(instance.getMaxRequestsPerConnection()); 
            this.withMaxRetries(instance.getMaxRetries()); 
    }

    public Integer getHttp1MaxPendingRequests(){
            return this.http1MaxPendingRequests;
    }

    public A withHttp1MaxPendingRequests(Integer http1MaxPendingRequests){
            this.http1MaxPendingRequests=http1MaxPendingRequests; return (A) this;
    }

    public Boolean hasHttp1MaxPendingRequests(){
            return this.http1MaxPendingRequests != null;
    }

    public A withNewHttp1MaxPendingRequests(String arg1){
            return (A)withHttp1MaxPendingRequests(new Integer(arg1));
    }

    public A withNewHttp1MaxPendingRequests(int arg1){
            return (A)withHttp1MaxPendingRequests(new Integer(arg1));
    }

    public Integer getHttp2MaxRequests(){
            return this.http2MaxRequests;
    }

    public A withHttp2MaxRequests(Integer http2MaxRequests){
            this.http2MaxRequests=http2MaxRequests; return (A) this;
    }

    public Boolean hasHttp2MaxRequests(){
            return this.http2MaxRequests != null;
    }

    public A withNewHttp2MaxRequests(String arg1){
            return (A)withHttp2MaxRequests(new Integer(arg1));
    }

    public A withNewHttp2MaxRequests(int arg1){
            return (A)withHttp2MaxRequests(new Integer(arg1));
    }

    public Integer getMaxRequestsPerConnection(){
            return this.maxRequestsPerConnection;
    }

    public A withMaxRequestsPerConnection(Integer maxRequestsPerConnection){
            this.maxRequestsPerConnection=maxRequestsPerConnection; return (A) this;
    }

    public Boolean hasMaxRequestsPerConnection(){
            return this.maxRequestsPerConnection != null;
    }

    public A withNewMaxRequestsPerConnection(String arg1){
            return (A)withMaxRequestsPerConnection(new Integer(arg1));
    }

    public A withNewMaxRequestsPerConnection(int arg1){
            return (A)withMaxRequestsPerConnection(new Integer(arg1));
    }

    public Integer getMaxRetries(){
            return this.maxRetries;
    }

    public A withMaxRetries(Integer maxRetries){
            this.maxRetries=maxRetries; return (A) this;
    }

    public Boolean hasMaxRetries(){
            return this.maxRetries != null;
    }

    public A withNewMaxRetries(String arg1){
            return (A)withMaxRetries(new Integer(arg1));
    }

    public A withNewMaxRetries(int arg1){
            return (A)withMaxRetries(new Integer(arg1));
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            HTTPSettingsFluentImpl that = (HTTPSettingsFluentImpl) o;
            if (http1MaxPendingRequests != null ? !http1MaxPendingRequests.equals(that.http1MaxPendingRequests) :that.http1MaxPendingRequests != null) return false;
            if (http2MaxRequests != null ? !http2MaxRequests.equals(that.http2MaxRequests) :that.http2MaxRequests != null) return false;
            if (maxRequestsPerConnection != null ? !maxRequestsPerConnection.equals(that.maxRequestsPerConnection) :that.maxRequestsPerConnection != null) return false;
            if (maxRetries != null ? !maxRetries.equals(that.maxRetries) :that.maxRetries != null) return false;
            return true;
    }




}
