package me.snowdrop.istio.api.networking.v1alpha3;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
import javax.validation.Validator;

public class HttpCookieHashKeyBuilder extends HttpCookieHashKeyFluentImpl<HttpCookieHashKeyBuilder> implements VisitableBuilder<HttpCookieHashKey,HttpCookieHashKeyBuilder>{

    HttpCookieHashKeyFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public HttpCookieHashKeyBuilder(){
            this(true);
    }
    public HttpCookieHashKeyBuilder(Boolean validationEnabled){
            this(new HttpCookieHashKey(), validationEnabled);
    }
    public HttpCookieHashKeyBuilder(HttpCookieHashKeyFluent<?> fluent){
            this(fluent, true);
    }
    public HttpCookieHashKeyBuilder(HttpCookieHashKeyFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new HttpCookieHashKey(), validationEnabled);
    }
    public HttpCookieHashKeyBuilder(HttpCookieHashKeyFluent<?> fluent,HttpCookieHashKey instance){
            this(fluent, instance, true);
    }
    public HttpCookieHashKeyBuilder(HttpCookieHashKeyFluent<?> fluent,HttpCookieHashKey instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withHttpCookie(instance.getHttpCookie()); 
            this.validationEnabled = validationEnabled; 
    }
    public HttpCookieHashKeyBuilder(HttpCookieHashKey instance){
            this(instance,true);
    }
    public HttpCookieHashKeyBuilder(HttpCookieHashKey instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withHttpCookie(instance.getHttpCookie()); 
            this.validationEnabled = validationEnabled; 
    }
    public HttpCookieHashKeyBuilder(Validator validator){
            this(new HttpCookieHashKey(), true);
    }
    public HttpCookieHashKeyBuilder(HttpCookieHashKeyFluent<?> fluent,HttpCookieHashKey instance,Validator validator){
            this.fluent = fluent; 
            fluent.withHttpCookie(instance.getHttpCookie()); 
            this.validator = validator;
            this.validationEnabled = validator != null; 
    }
    public HttpCookieHashKeyBuilder(HttpCookieHashKey instance,Validator validator){
            this.fluent = this; 
            this.withHttpCookie(instance.getHttpCookie()); 
            this.validator = validator; 
            this.validationEnabled = validator != null; 
    }

    public HttpCookieHashKey build(){
            HttpCookieHashKey buildable = new HttpCookieHashKey(fluent.getHttpCookie());
            if (validationEnabled) {io.fabric8.kubernetes.api.builder.ValidationUtils.validate(buildable);}
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            HttpCookieHashKeyBuilder that = (HttpCookieHashKeyBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
