
package me.snowdrop.istio.api.networking.v1alpha3;

import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.fabric8.kubernetes.api.model.Doneable;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.BuildableReference;
import io.sundr.builder.annotations.Inline;
import lombok.EqualsAndHashCode;
import lombok.ToString;
import me.snowdrop.istio.api.networking.v1alpha3.Abort.ErrorType;


/**
 * 
 * 
 */
@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder({
    "apiVersion",
    "kind",
    "metadata",
    "httpStatus"
})
@ToString
@EqualsAndHashCode
@Buildable(editableEnabled = false, validationEnabled = true, generateBuilderPackage = true, builderPackage = "io.fabric8.kubernetes.api.builder", inline = {
    @Inline(type = Doneable.class, prefix = "Doneable", value = "done")
}, refs = {
    @BuildableReference(ObjectMeta.class)
})
public class HttpStatusErrorType implements Serializable, ErrorType
{

    /**
     * 
     * 
     */
    @JsonProperty("httpStatus")
    @JsonPropertyDescription("")
    private Integer httpStatus;
    private final static long serialVersionUID = 7227733698410015036L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public HttpStatusErrorType() {
    }

    /**
     * 
     * @param httpStatus
     */
    public HttpStatusErrorType(Integer httpStatus) {
        super();
        this.httpStatus = httpStatus;
    }

    /**
     * 
     * 
     */
    @JsonProperty("httpStatus")
    public Integer getHttpStatus() {
        return httpStatus;
    }

    /**
     * 
     * 
     */
    @JsonProperty("httpStatus")
    public void setHttpStatus(Integer httpStatus) {
        this.httpStatus = httpStatus;
    }

}
