
package me.snowdrop.istio.api.networking.v1alpha3;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.validation.Valid;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.fabric8.kubernetes.api.model.Doneable;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.BuildableReference;
import io.sundr.builder.annotations.Inline;
import lombok.EqualsAndHashCode;
import lombok.ToString;


/**
 * 
 * 
 */
@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder({
    "apiVersion",
    "kind",
    "metadata",
    "address",
    "listenerProtocol",
    "listenerType",
    "portNamePrefix",
    "portNumber"
})
@ToString
@EqualsAndHashCode
@Buildable(editableEnabled = false, validationEnabled = true, generateBuilderPackage = true, builderPackage = "io.fabric8.kubernetes.api.builder", inline = {
    @Inline(type = Doneable.class, prefix = "Doneable", value = "done")
}, refs = {
    @BuildableReference(ObjectMeta.class)
})
public class ListenerMatch implements Serializable
{

    /**
     * 
     * 
     */
    @JsonProperty("address")
    @JsonPropertyDescription("")
    @Valid
    private List<String> address = new ArrayList<String>();
    @JsonProperty("listenerProtocol")
    private ListenerProtocol listenerProtocol;
    @JsonProperty("listenerType")
    private ListenerType listenerType;
    /**
     * 
     * 
     */
    @JsonProperty("portNamePrefix")
    @JsonPropertyDescription("")
    private String portNamePrefix;
    /**
     * 
     * 
     */
    @JsonProperty("portNumber")
    @JsonPropertyDescription("")
    private Integer portNumber;
    private final static long serialVersionUID = 5642167638134262364L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public ListenerMatch() {
    }

    /**
     * 
     * @param address
     * @param listenerType
     * @param listenerProtocol
     * @param portNamePrefix
     * @param portNumber
     */
    public ListenerMatch(List<String> address, ListenerProtocol listenerProtocol, ListenerType listenerType, String portNamePrefix, Integer portNumber) {
        super();
        this.address = address;
        this.listenerProtocol = listenerProtocol;
        this.listenerType = listenerType;
        this.portNamePrefix = portNamePrefix;
        this.portNumber = portNumber;
    }

    /**
     * 
     * 
     */
    @JsonProperty("address")
    public List<String> getAddress() {
        return address;
    }

    /**
     * 
     * 
     */
    @JsonProperty("address")
    public void setAddress(List<String> address) {
        this.address = address;
    }

    @JsonProperty("listenerProtocol")
    public ListenerProtocol getListenerProtocol() {
        return listenerProtocol;
    }

    @JsonProperty("listenerProtocol")
    public void setListenerProtocol(ListenerProtocol listenerProtocol) {
        this.listenerProtocol = listenerProtocol;
    }

    @JsonProperty("listenerType")
    public ListenerType getListenerType() {
        return listenerType;
    }

    @JsonProperty("listenerType")
    public void setListenerType(ListenerType listenerType) {
        this.listenerType = listenerType;
    }

    /**
     * 
     * 
     */
    @JsonProperty("portNamePrefix")
    public String getPortNamePrefix() {
        return portNamePrefix;
    }

    /**
     * 
     * 
     */
    @JsonProperty("portNamePrefix")
    public void setPortNamePrefix(String portNamePrefix) {
        this.portNamePrefix = portNamePrefix;
    }

    /**
     * 
     * 
     */
    @JsonProperty("portNumber")
    public Integer getPortNumber() {
        return portNumber;
    }

    /**
     * 
     * 
     */
    @JsonProperty("portNumber")
    public void setPortNumber(Integer portNumber) {
        this.portNumber = portNumber;
    }

}
