package me.snowdrop.istio.api.networking.v1alpha3;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
import javax.validation.Validator;

public class ListenerMatchBuilder extends ListenerMatchFluentImpl<ListenerMatchBuilder> implements VisitableBuilder<ListenerMatch,ListenerMatchBuilder>{

    ListenerMatchFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public ListenerMatchBuilder(){
            this(true);
    }
    public ListenerMatchBuilder(Boolean validationEnabled){
            this(new ListenerMatch(), validationEnabled);
    }
    public ListenerMatchBuilder(ListenerMatchFluent<?> fluent){
            this(fluent, true);
    }
    public ListenerMatchBuilder(ListenerMatchFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new ListenerMatch(), validationEnabled);
    }
    public ListenerMatchBuilder(ListenerMatchFluent<?> fluent,ListenerMatch instance){
            this(fluent, instance, true);
    }
    public ListenerMatchBuilder(ListenerMatchFluent<?> fluent,ListenerMatch instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withAddress(instance.getAddress()); 
            fluent.withListenerProtocol(instance.getListenerProtocol()); 
            fluent.withListenerType(instance.getListenerType()); 
            fluent.withPortNamePrefix(instance.getPortNamePrefix()); 
            fluent.withPortNumber(instance.getPortNumber()); 
            this.validationEnabled = validationEnabled; 
    }
    public ListenerMatchBuilder(ListenerMatch instance){
            this(instance,true);
    }
    public ListenerMatchBuilder(ListenerMatch instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withAddress(instance.getAddress()); 
            this.withListenerProtocol(instance.getListenerProtocol()); 
            this.withListenerType(instance.getListenerType()); 
            this.withPortNamePrefix(instance.getPortNamePrefix()); 
            this.withPortNumber(instance.getPortNumber()); 
            this.validationEnabled = validationEnabled; 
    }
    public ListenerMatchBuilder(Validator validator){
            this(new ListenerMatch(), true);
    }
    public ListenerMatchBuilder(ListenerMatchFluent<?> fluent,ListenerMatch instance,Validator validator){
            this.fluent = fluent; 
            fluent.withAddress(instance.getAddress()); 
            fluent.withListenerProtocol(instance.getListenerProtocol()); 
            fluent.withListenerType(instance.getListenerType()); 
            fluent.withPortNamePrefix(instance.getPortNamePrefix()); 
            fluent.withPortNumber(instance.getPortNumber()); 
            this.validator = validator;
            this.validationEnabled = validator != null; 
    }
    public ListenerMatchBuilder(ListenerMatch instance,Validator validator){
            this.fluent = this; 
            this.withAddress(instance.getAddress()); 
            this.withListenerProtocol(instance.getListenerProtocol()); 
            this.withListenerType(instance.getListenerType()); 
            this.withPortNamePrefix(instance.getPortNamePrefix()); 
            this.withPortNumber(instance.getPortNumber()); 
            this.validator = validator; 
            this.validationEnabled = validator != null; 
    }

    public ListenerMatch build(){
            ListenerMatch buildable = new ListenerMatch(fluent.getAddress(),fluent.getListenerProtocol(),fluent.getListenerType(),fluent.getPortNamePrefix(),fluent.getPortNumber());
            if (validationEnabled) {io.fabric8.kubernetes.api.builder.ValidationUtils.validate(buildable);}
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            ListenerMatchBuilder that = (ListenerMatchBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
