
package me.snowdrop.istio.api.networking.v1alpha3;

import java.io.Serializable;
import javax.validation.Valid;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.fabric8.kubernetes.api.model.Doneable;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.BuildableReference;
import io.sundr.builder.annotations.Inline;
import lombok.EqualsAndHashCode;
import lombok.ToString;


/**
 * 
 * 
 */
@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder({
    "apiVersion",
    "kind",
    "metadata",
    "connectionPool",
    "loadBalancer",
    "outlierDetection",
    "port",
    "tls"
})
@ToString
@EqualsAndHashCode
@Buildable(editableEnabled = false, validationEnabled = true, generateBuilderPackage = true, builderPackage = "io.fabric8.kubernetes.api.builder", inline = {
    @Inline(type = Doneable.class, prefix = "Doneable", value = "done")
}, refs = {
    @BuildableReference(ObjectMeta.class)
})
public class PortTrafficPolicy implements Serializable
{

    /**
     * 
     * 
     */
    @JsonProperty("connectionPool")
    @JsonPropertyDescription("")
    @Valid
    private ConnectionPoolSettings connectionPool;
    /**
     * 
     * 
     */
    @JsonProperty("loadBalancer")
    @JsonPropertyDescription("")
    @Valid
    private LoadBalancerSettings loadBalancer;
    /**
     * 
     * 
     */
    @JsonProperty("outlierDetection")
    @JsonPropertyDescription("")
    @Valid
    private OutlierDetection outlierDetection;
    /**
     * 
     * 
     */
    @JsonProperty("port")
    @JsonPropertyDescription("")
    @Valid
    private PortSelector port;
    /**
     * 
     * 
     */
    @JsonProperty("tls")
    @JsonPropertyDescription("")
    @Valid
    private TLSSettings tls;
    private final static long serialVersionUID = -7122313286852806257L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public PortTrafficPolicy() {
    }

    /**
     * 
     * @param port
     * @param loadBalancer
     * @param connectionPool
     * @param tls
     * @param outlierDetection
     */
    public PortTrafficPolicy(ConnectionPoolSettings connectionPool, LoadBalancerSettings loadBalancer, OutlierDetection outlierDetection, PortSelector port, TLSSettings tls) {
        super();
        this.connectionPool = connectionPool;
        this.loadBalancer = loadBalancer;
        this.outlierDetection = outlierDetection;
        this.port = port;
        this.tls = tls;
    }

    /**
     * 
     * 
     */
    @JsonProperty("connectionPool")
    public ConnectionPoolSettings getConnectionPool() {
        return connectionPool;
    }

    /**
     * 
     * 
     */
    @JsonProperty("connectionPool")
    public void setConnectionPool(ConnectionPoolSettings connectionPool) {
        this.connectionPool = connectionPool;
    }

    /**
     * 
     * 
     */
    @JsonProperty("loadBalancer")
    public LoadBalancerSettings getLoadBalancer() {
        return loadBalancer;
    }

    /**
     * 
     * 
     */
    @JsonProperty("loadBalancer")
    public void setLoadBalancer(LoadBalancerSettings loadBalancer) {
        this.loadBalancer = loadBalancer;
    }

    /**
     * 
     * 
     */
    @JsonProperty("outlierDetection")
    public OutlierDetection getOutlierDetection() {
        return outlierDetection;
    }

    /**
     * 
     * 
     */
    @JsonProperty("outlierDetection")
    public void setOutlierDetection(OutlierDetection outlierDetection) {
        this.outlierDetection = outlierDetection;
    }

    /**
     * 
     * 
     */
    @JsonProperty("port")
    public PortSelector getPort() {
        return port;
    }

    /**
     * 
     * 
     */
    @JsonProperty("port")
    public void setPort(PortSelector port) {
        this.port = port;
    }

    /**
     * 
     * 
     */
    @JsonProperty("tls")
    public TLSSettings getTls() {
        return tls;
    }

    /**
     * 
     * 
     */
    @JsonProperty("tls")
    public void setTls(TLSSettings tls) {
        this.tls = tls;
    }

}
