
package me.snowdrop.istio.api.networking.v1alpha3;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.validation.Valid;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.fabric8.kubernetes.api.model.Doneable;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.BuildableReference;
import io.sundr.builder.annotations.Inline;
import lombok.EqualsAndHashCode;
import lombok.ToString;


/**
 * 
 * 
 */
@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder({
    "apiVersion",
    "kind",
    "metadata",
    "hosts",
    "port",
    "tls"
})
@ToString
@EqualsAndHashCode
@Buildable(editableEnabled = false, validationEnabled = true, generateBuilderPackage = true, builderPackage = "io.fabric8.kubernetes.api.builder", inline = {
    @Inline(type = Doneable.class, prefix = "Doneable", value = "done")
}, refs = {
    @BuildableReference(ObjectMeta.class)
})
public class Server implements Serializable
{

    /**
     * 
     * 
     */
    @JsonProperty("hosts")
    @JsonPropertyDescription("")
    @Valid
    private List<String> hosts = new ArrayList<String>();
    /**
     * 
     * 
     */
    @JsonProperty("port")
    @JsonPropertyDescription("")
    @Valid
    private Port port;
    /**
     * 
     * 
     */
    @JsonProperty("tls")
    @JsonPropertyDescription("")
    @Valid
    private TLSOptions tls;
    private final static long serialVersionUID = -824857379038919235L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public Server() {
    }

    /**
     * 
     * @param port
     * @param hosts
     * @param tls
     */
    public Server(List<String> hosts, Port port, TLSOptions tls) {
        super();
        this.hosts = hosts;
        this.port = port;
        this.tls = tls;
    }

    /**
     * 
     * 
     */
    @JsonProperty("hosts")
    public List<String> getHosts() {
        return hosts;
    }

    /**
     * 
     * 
     */
    @JsonProperty("hosts")
    public void setHosts(List<String> hosts) {
        this.hosts = hosts;
    }

    /**
     * 
     * 
     */
    @JsonProperty("port")
    public Port getPort() {
        return port;
    }

    /**
     * 
     * 
     */
    @JsonProperty("port")
    public void setPort(Port port) {
        this.port = port;
    }

    /**
     * 
     * 
     */
    @JsonProperty("tls")
    public TLSOptions getTls() {
        return tls;
    }

    /**
     * 
     * 
     */
    @JsonProperty("tls")
    public void setTls(TLSOptions tls) {
        this.tls = tls;
    }

}
