package me.snowdrop.istio.api.networking.v1alpha3;

import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import javax.validation.constraints.NotNull;
import io.fabric8.kubernetes.api.builder.Predicate;
import io.fabric8.kubernetes.api.model.ListMeta;
import java.lang.Deprecated;
import javax.validation.Valid;
import java.util.Collection;
import java.util.List;
import java.lang.Boolean;

public interface ServiceEntryListFluent<A extends ServiceEntryListFluent<A>> extends Fluent<A>{


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public Boolean hasApiVersion();
    public A addToItems(int index,ServiceEntry item);
    public A setToItems(int index,ServiceEntry item);
    public A addToItems(ServiceEntry... items);
    public A addAllToItems(Collection<ServiceEntry> items);
    public A removeFromItems(ServiceEntry... items);
    public A removeAllFromItems(Collection<ServiceEntry> items);
    
/**
 * This method has been deprecated, please use method buildItems instead.
 * @return The buildable object.
 */
@Deprecated public List<ServiceEntry> getItems();
    public List<ServiceEntry> buildItems();
    public ServiceEntry buildItem(int index);
    public ServiceEntry buildFirstItem();
    public ServiceEntry buildLastItem();
    public ServiceEntry buildMatchingItem(Predicate<ServiceEntryBuilder> predicate);
    public A withItems(List<ServiceEntry> items);
    public A withItems(ServiceEntry... items);
    public Boolean hasItems();
    public ServiceEntryListFluent.ItemsNested<A> addNewItem();
    public ServiceEntryListFluent.ItemsNested<A> addNewItemLike(ServiceEntry item);
    public ServiceEntryListFluent.ItemsNested<A> setNewItemLike(int index,ServiceEntry item);
    public ServiceEntryListFluent.ItemsNested<A> editItem(int index);
    public ServiceEntryListFluent.ItemsNested<A> editFirstItem();
    public ServiceEntryListFluent.ItemsNested<A> editLastItem();
    public ServiceEntryListFluent.ItemsNested<A> editMatchingItem(Predicate<ServiceEntryBuilder> predicate);
    public String getKind();
    public A withKind(String kind);
    public Boolean hasKind();
    public ListMeta getMetadata();
    public A withMetadata(ListMeta metadata);
    public Boolean hasMetadata();
    public A withNewMetadata(String _continue,String resourceVersion,String selfLink);

    public interface ItemsNested<N> extends Nested<N>,ServiceEntryFluent<ServiceEntryListFluent.ItemsNested<N>>{

        
    public N and();    public N endItem();
}


}
