package me.snowdrop.istio.api.networking.v1alpha3;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
import javax.validation.Validator;

public class TCPRouteBuilder extends TCPRouteFluentImpl<TCPRouteBuilder> implements VisitableBuilder<TCPRoute,TCPRouteBuilder>{

    TCPRouteFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public TCPRouteBuilder(){
            this(true);
    }
    public TCPRouteBuilder(Boolean validationEnabled){
            this(new TCPRoute(), validationEnabled);
    }
    public TCPRouteBuilder(TCPRouteFluent<?> fluent){
            this(fluent, true);
    }
    public TCPRouteBuilder(TCPRouteFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new TCPRoute(), validationEnabled);
    }
    public TCPRouteBuilder(TCPRouteFluent<?> fluent,TCPRoute instance){
            this(fluent, instance, true);
    }
    public TCPRouteBuilder(TCPRouteFluent<?> fluent,TCPRoute instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withMatch(instance.getMatch()); 
            fluent.withRoute(instance.getRoute()); 
            this.validationEnabled = validationEnabled; 
    }
    public TCPRouteBuilder(TCPRoute instance){
            this(instance,true);
    }
    public TCPRouteBuilder(TCPRoute instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withMatch(instance.getMatch()); 
            this.withRoute(instance.getRoute()); 
            this.validationEnabled = validationEnabled; 
    }
    public TCPRouteBuilder(Validator validator){
            this(new TCPRoute(), true);
    }
    public TCPRouteBuilder(TCPRouteFluent<?> fluent,TCPRoute instance,Validator validator){
            this.fluent = fluent; 
            fluent.withMatch(instance.getMatch()); 
            fluent.withRoute(instance.getRoute()); 
            this.validator = validator;
            this.validationEnabled = validator != null; 
    }
    public TCPRouteBuilder(TCPRoute instance,Validator validator){
            this.fluent = this; 
            this.withMatch(instance.getMatch()); 
            this.withRoute(instance.getRoute()); 
            this.validator = validator; 
            this.validationEnabled = validator != null; 
    }

    public TCPRoute build(){
            TCPRoute buildable = new TCPRoute(fluent.getMatch(),fluent.getRoute());
            if (validationEnabled) {io.fabric8.kubernetes.api.builder.ValidationUtils.validate(buildable);}
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            TCPRouteBuilder that = (TCPRouteBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
