package me.snowdrop.istio.api.networking.v1alpha3;

import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import io.fabric8.kubernetes.api.builder.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.List;
import java.lang.Boolean;
import javax.validation.Valid;
import java.util.Collection;
import java.lang.Object;

public class TLSRouteFluentImpl<A extends TLSRouteFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements TLSRouteFluent<A>{

    private List<TLSMatchAttributesBuilder> match;
    private List<DestinationWeightBuilder> route;

    public TLSRouteFluentImpl(){
    }
    public TLSRouteFluentImpl(TLSRoute instance){
            this.withMatch(instance.getMatch()); 
            this.withRoute(instance.getRoute()); 
    }

    public A addToMatch(int index,TLSMatchAttributes item){
            if (this.match == null) {this.match = new ArrayList<TLSMatchAttributesBuilder>();}
            TLSMatchAttributesBuilder builder = new TLSMatchAttributesBuilder(item);_visitables.add(index >= 0 ? index : _visitables.size(), builder);this.match.add(index >= 0 ? index : match.size(), builder); return (A)this;
    }

    public A setToMatch(int index,TLSMatchAttributes item){
            if (this.match == null) {this.match = new ArrayList<TLSMatchAttributesBuilder>();}
            TLSMatchAttributesBuilder builder = new TLSMatchAttributesBuilder(item);
            if (index < 0 || index >= _visitables.size()) { _visitables.add(builder); } else { _visitables.set(index, builder);}
            if (index < 0 || index >= match.size()) { match.add(builder); } else { match.set(index, builder);}
             return (A)this;
    }

    public A addToMatch(TLSMatchAttributes... items){
            if (this.match == null) {this.match = new ArrayList<TLSMatchAttributesBuilder>();}
            for (TLSMatchAttributes item : items) {TLSMatchAttributesBuilder builder = new TLSMatchAttributesBuilder(item);_visitables.add(builder);this.match.add(builder);} return (A)this;
    }

    public A addAllToMatch(Collection<TLSMatchAttributes> items){
            if (this.match == null) {this.match = new ArrayList<TLSMatchAttributesBuilder>();}
            for (TLSMatchAttributes item : items) {TLSMatchAttributesBuilder builder = new TLSMatchAttributesBuilder(item);_visitables.add(builder);this.match.add(builder);} return (A)this;
    }

    public A removeFromMatch(TLSMatchAttributes... items){
            for (TLSMatchAttributes item : items) {TLSMatchAttributesBuilder builder = new TLSMatchAttributesBuilder(item);_visitables.remove(builder);if (this.match != null) {this.match.remove(builder);}} return (A)this;
    }

    public A removeAllFromMatch(Collection<TLSMatchAttributes> items){
            for (TLSMatchAttributes item : items) {TLSMatchAttributesBuilder builder = new TLSMatchAttributesBuilder(item);_visitables.remove(builder);if (this.match != null) {this.match.remove(builder);}} return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildMatch instead.
 * @return The buildable object.
 */
@Deprecated public List<TLSMatchAttributes> getMatch(){
            return build(match);
    }

    public List<TLSMatchAttributes> buildMatch(){
            return build(match);
    }

    public TLSMatchAttributes buildMatch(int index){
            return this.match.get(index).build();
    }

    public TLSMatchAttributes buildFirstMatch(){
            return this.match.get(0).build();
    }

    public TLSMatchAttributes buildLastMatch(){
            return this.match.get(match.size() - 1).build();
    }

    public TLSMatchAttributes buildMatchingMatch(io.fabric8.kubernetes.api.builder.Predicate<TLSMatchAttributesBuilder> predicate){
            for (TLSMatchAttributesBuilder item: match) { if(predicate.apply(item)){return item.build();} } return null;
    }

    public A withMatch(List<TLSMatchAttributes> match){
            if (this.match != null) { _visitables.removeAll(this.match);}
            if (match != null) {this.match = new ArrayList<TLSMatchAttributesBuilder>(); for (TLSMatchAttributes item : match){this.addToMatch(item);}} else { this.match = null;} return (A) this;
    }

    public A withMatch(TLSMatchAttributes... match){
            if (this.match != null) {this.match.clear();}
            if (match != null) {for (TLSMatchAttributes item :match){ this.addToMatch(item);}} return (A) this;
    }

    public Boolean hasMatch(){
            return match != null && !match.isEmpty();
    }

    public TLSRouteFluent.MatchNested<A> addNewMatch(){
            return new MatchNestedImpl();
    }

    public TLSRouteFluent.MatchNested<A> addNewMatchLike(TLSMatchAttributes item){
            return new MatchNestedImpl(-1, item);
    }

    public TLSRouteFluent.MatchNested<A> setNewMatchLike(int index,TLSMatchAttributes item){
            return new MatchNestedImpl(index, item);
    }

    public TLSRouteFluent.MatchNested<A> editMatch(int index){
            if (match.size() <= index) throw new RuntimeException("Can't edit match. Index exceeds size.");
            return setNewMatchLike(index, buildMatch(index));
    }

    public TLSRouteFluent.MatchNested<A> editFirstMatch(){
            if (match.size() == 0) throw new RuntimeException("Can't edit first match. The list is empty.");
            return setNewMatchLike(0, buildMatch(0));
    }

    public TLSRouteFluent.MatchNested<A> editLastMatch(){
            int index = match.size() - 1;
            if (index < 0) throw new RuntimeException("Can't edit last match. The list is empty.");
            return setNewMatchLike(index, buildMatch(index));
    }

    public TLSRouteFluent.MatchNested<A> editMatchingMatch(io.fabric8.kubernetes.api.builder.Predicate<TLSMatchAttributesBuilder> predicate){
            int index = -1;
            for (int i=0;i<match.size();i++) { 
            if (predicate.apply(match.get(i))) {index = i; break;}
            } 
            if (index < 0) throw new RuntimeException("Can't edit matching match. No match found.");
            return setNewMatchLike(index, buildMatch(index));
    }

    public A addToRoute(int index,DestinationWeight item){
            if (this.route == null) {this.route = new ArrayList<DestinationWeightBuilder>();}
            DestinationWeightBuilder builder = new DestinationWeightBuilder(item);_visitables.add(index >= 0 ? index : _visitables.size(), builder);this.route.add(index >= 0 ? index : route.size(), builder); return (A)this;
    }

    public A setToRoute(int index,DestinationWeight item){
            if (this.route == null) {this.route = new ArrayList<DestinationWeightBuilder>();}
            DestinationWeightBuilder builder = new DestinationWeightBuilder(item);
            if (index < 0 || index >= _visitables.size()) { _visitables.add(builder); } else { _visitables.set(index, builder);}
            if (index < 0 || index >= route.size()) { route.add(builder); } else { route.set(index, builder);}
             return (A)this;
    }

    public A addToRoute(DestinationWeight... items){
            if (this.route == null) {this.route = new ArrayList<DestinationWeightBuilder>();}
            for (DestinationWeight item : items) {DestinationWeightBuilder builder = new DestinationWeightBuilder(item);_visitables.add(builder);this.route.add(builder);} return (A)this;
    }

    public A addAllToRoute(Collection<DestinationWeight> items){
            if (this.route == null) {this.route = new ArrayList<DestinationWeightBuilder>();}
            for (DestinationWeight item : items) {DestinationWeightBuilder builder = new DestinationWeightBuilder(item);_visitables.add(builder);this.route.add(builder);} return (A)this;
    }

    public A removeFromRoute(DestinationWeight... items){
            for (DestinationWeight item : items) {DestinationWeightBuilder builder = new DestinationWeightBuilder(item);_visitables.remove(builder);if (this.route != null) {this.route.remove(builder);}} return (A)this;
    }

    public A removeAllFromRoute(Collection<DestinationWeight> items){
            for (DestinationWeight item : items) {DestinationWeightBuilder builder = new DestinationWeightBuilder(item);_visitables.remove(builder);if (this.route != null) {this.route.remove(builder);}} return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildRoute instead.
 * @return The buildable object.
 */
@Deprecated public List<DestinationWeight> getRoute(){
            return build(route);
    }

    public List<DestinationWeight> buildRoute(){
            return build(route);
    }

    public DestinationWeight buildRoute(int index){
            return this.route.get(index).build();
    }

    public DestinationWeight buildFirstRoute(){
            return this.route.get(0).build();
    }

    public DestinationWeight buildLastRoute(){
            return this.route.get(route.size() - 1).build();
    }

    public DestinationWeight buildMatchingRoute(io.fabric8.kubernetes.api.builder.Predicate<DestinationWeightBuilder> predicate){
            for (DestinationWeightBuilder item: route) { if(predicate.apply(item)){return item.build();} } return null;
    }

    public A withRoute(List<DestinationWeight> route){
            if (this.route != null) { _visitables.removeAll(this.route);}
            if (route != null) {this.route = new ArrayList<DestinationWeightBuilder>(); for (DestinationWeight item : route){this.addToRoute(item);}} else { this.route = null;} return (A) this;
    }

    public A withRoute(DestinationWeight... route){
            if (this.route != null) {this.route.clear();}
            if (route != null) {for (DestinationWeight item :route){ this.addToRoute(item);}} return (A) this;
    }

    public Boolean hasRoute(){
            return route != null && !route.isEmpty();
    }

    public TLSRouteFluent.RouteNested<A> addNewRoute(){
            return new RouteNestedImpl();
    }

    public TLSRouteFluent.RouteNested<A> addNewRouteLike(DestinationWeight item){
            return new RouteNestedImpl(-1, item);
    }

    public TLSRouteFluent.RouteNested<A> setNewRouteLike(int index,DestinationWeight item){
            return new RouteNestedImpl(index, item);
    }

    public TLSRouteFluent.RouteNested<A> editRoute(int index){
            if (route.size() <= index) throw new RuntimeException("Can't edit route. Index exceeds size.");
            return setNewRouteLike(index, buildRoute(index));
    }

    public TLSRouteFluent.RouteNested<A> editFirstRoute(){
            if (route.size() == 0) throw new RuntimeException("Can't edit first route. The list is empty.");
            return setNewRouteLike(0, buildRoute(0));
    }

    public TLSRouteFluent.RouteNested<A> editLastRoute(){
            int index = route.size() - 1;
            if (index < 0) throw new RuntimeException("Can't edit last route. The list is empty.");
            return setNewRouteLike(index, buildRoute(index));
    }

    public TLSRouteFluent.RouteNested<A> editMatchingRoute(io.fabric8.kubernetes.api.builder.Predicate<DestinationWeightBuilder> predicate){
            int index = -1;
            for (int i=0;i<route.size();i++) { 
            if (predicate.apply(route.get(i))) {index = i; break;}
            } 
            if (index < 0) throw new RuntimeException("Can't edit matching route. No match found.");
            return setNewRouteLike(index, buildRoute(index));
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            TLSRouteFluentImpl that = (TLSRouteFluentImpl) o;
            if (match != null ? !match.equals(that.match) :that.match != null) return false;
            if (route != null ? !route.equals(that.route) :that.route != null) return false;
            return true;
    }


    public class MatchNestedImpl<N> extends TLSMatchAttributesFluentImpl<TLSRouteFluent.MatchNested<N>> implements TLSRouteFluent.MatchNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final TLSMatchAttributesBuilder builder;
        private final int index;
    
            MatchNestedImpl(int index,TLSMatchAttributes item){
                    this.index = index;
                    this.builder = new TLSMatchAttributesBuilder(this, item);
            }
            MatchNestedImpl(){
                    this.index = -1;
                    this.builder = new TLSMatchAttributesBuilder(this);
            }
    
    public N and(){
            return (N) TLSRouteFluentImpl.this.setToMatch(index, builder.build());
    }
    public N endMatch(){
            return and();
    }

}
    public class RouteNestedImpl<N> extends DestinationWeightFluentImpl<TLSRouteFluent.RouteNested<N>> implements TLSRouteFluent.RouteNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final DestinationWeightBuilder builder;
        private final int index;
    
            RouteNestedImpl(int index,DestinationWeight item){
                    this.index = index;
                    this.builder = new DestinationWeightBuilder(this, item);
            }
            RouteNestedImpl(){
                    this.index = -1;
                    this.builder = new DestinationWeightBuilder(this);
            }
    
    public N and(){
            return (N) TLSRouteFluentImpl.this.setToRoute(index, builder.build());
    }
    public N endRoute(){
            return and();
    }

}


}
