
package me.snowdrop.istio.api.policy.v1beta1;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.validation.Valid;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.fabric8.kubernetes.api.model.Doneable;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.BuildableReference;
import io.sundr.builder.annotations.Inline;
import lombok.EqualsAndHashCode;
import lombok.ToString;


/**
 * 
 * 
 */
@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder({
    "apiVersion",
    "kind",
    "metadata",
    "handler",
    "instances"
})
@ToString
@EqualsAndHashCode
@Buildable(editableEnabled = false, validationEnabled = true, generateBuilderPackage = true, builderPackage = "io.fabric8.kubernetes.api.builder", inline = {
    @Inline(type = Doneable.class, prefix = "Doneable", value = "done")
}, refs = {
    @BuildableReference(ObjectMeta.class)
})
public class Action implements Serializable
{

    /**
     * 
     * 
     */
    @JsonProperty("handler")
    @JsonPropertyDescription("")
    private String handler;
    /**
     * 
     * 
     */
    @JsonProperty("instances")
    @JsonPropertyDescription("")
    @Valid
    private List<String> instances = new ArrayList<String>();
    private final static long serialVersionUID = -8245676413444571870L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public Action() {
    }

    /**
     * 
     * @param handler
     * @param instances
     */
    public Action(String handler, List<String> instances) {
        super();
        this.handler = handler;
        this.instances = instances;
    }

    /**
     * 
     * 
     */
    @JsonProperty("handler")
    public String getHandler() {
        return handler;
    }

    /**
     * 
     * 
     */
    @JsonProperty("handler")
    public void setHandler(String handler) {
        this.handler = handler;
    }

    /**
     * 
     * 
     */
    @JsonProperty("instances")
    public List<String> getInstances() {
        return instances;
    }

    /**
     * 
     * 
     */
    @JsonProperty("instances")
    public void setInstances(List<String> instances) {
        this.instances = instances;
    }

}
