package me.snowdrop.istio.api.policy.v1beta1;

import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonProperty;
import javax.validation.Valid;
import io.fabric8.kubernetes.api.builder.Fluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.lang.String;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.builder.Predicate;

public interface ActionFluent<A extends ActionFluent<A>> extends Fluent<A>{


    public String getHandler();
    public A withHandler(String handler);
    public Boolean hasHandler();
    public A addToInstances(int index,String item);
    public A setToInstances(int index,String item);
    public A addToInstances(String... items);
    public A addAllToInstances(Collection<String> items);
    public A removeFromInstances(String... items);
    public A removeAllFromInstances(Collection<String> items);
    public List<String> getInstances();
    public String getInstance(int index);
    public String getFirstInstance();
    public String getLastInstance();
    public String getMatchingInstance(io.fabric8.kubernetes.api.builder.Predicate<String> predicate);
    public A withInstances(List<String> instances);
    public A withInstances(String... instances);
    public Boolean hasInstances();



}
