
package me.snowdrop.istio.api.policy.v1beta1;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.validation.Valid;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.fabric8.kubernetes.api.model.Doneable;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.BuildableReference;
import io.sundr.builder.annotations.Inline;
import io.sundr.transform.annotations.VelocityTransformation;
import io.sundr.transform.annotations.VelocityTransformations;
import lombok.EqualsAndHashCode;
import lombok.ToString;
import me.snowdrop.istio.api.IstioSpec;
import me.snowdrop.istio.api.internal.IstioApiVersion;
import me.snowdrop.istio.api.internal.IstioKind;


/**
 * 
 * 
 */
@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder({
    "apiVersion",
    "kind",
    "metadata",
    "actions",
    "match"
})
@IstioKind(name = "rule", plural = "rules")
@IstioApiVersion("config.istio.io/v1alpha2")
@ToString
@EqualsAndHashCode
@Buildable(editableEnabled = false, validationEnabled = true, generateBuilderPackage = true, builderPackage = "io.fabric8.kubernetes.api.builder", inline = {
    @Inline(type = Doneable.class, prefix = "Doneable", value = "done")
}, refs = {
    @BuildableReference(ObjectMeta.class)
})
@VelocityTransformations({
    @VelocityTransformation("/istio-resource.vm"),
    @VelocityTransformation("/istio-resource-list.vm"),
    @VelocityTransformation(value = "/istio-manifest.vm", outputPath = "crd.properties", gather = true),
    @VelocityTransformation(value = "/istio-mappings-provider.vm", outputPath = "me/snowdrop/istio/api/model/IstioResourceMappingsProvider.java", gather = true)
})
public class RuleSpec implements Serializable, IstioSpec
{

    /**
     * 
     * 
     */
    @JsonProperty("actions")
    @JsonPropertyDescription("")
    @Valid
    private List<Action> actions = new ArrayList<Action>();
    /**
     * 
     * 
     */
    @JsonProperty("match")
    @JsonPropertyDescription("")
    private String match;
    private final static long serialVersionUID = -8960555180784290223L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public RuleSpec() {
    }

    /**
     * 
     * @param match
     * @param actions
     */
    public RuleSpec(List<Action> actions, String match) {
        super();
        this.actions = actions;
        this.match = match;
    }

    /**
     * 
     * 
     */
    @JsonProperty("actions")
    public List<Action> getActions() {
        return actions;
    }

    /**
     * 
     * 
     */
    @JsonProperty("actions")
    public void setActions(List<Action> actions) {
        this.actions = actions;
    }

    /**
     * 
     * 
     */
    @JsonProperty("match")
    public String getMatch() {
        return match;
    }

    /**
     * 
     * 
     */
    @JsonProperty("match")
    public void setMatch(String match) {
        this.match = match;
    }

}
