package me.snowdrop.istio.api.policy.v1beta1;

import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.builder.Predicate;
import java.lang.Deprecated;
import javax.validation.Valid;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;

public class RuleSpecFluentImpl<A extends RuleSpecFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements RuleSpecFluent<A>{

    private List<ActionBuilder> actions;
    private String match;

    public RuleSpecFluentImpl(){
    }
    public RuleSpecFluentImpl(RuleSpec instance){
            this.withActions(instance.getActions()); 
            this.withMatch(instance.getMatch()); 
    }

    public A addToActions(int index,Action item){
            if (this.actions == null) {this.actions = new ArrayList<ActionBuilder>();}
            ActionBuilder builder = new ActionBuilder(item);_visitables.add(index >= 0 ? index : _visitables.size(), builder);this.actions.add(index >= 0 ? index : actions.size(), builder); return (A)this;
    }

    public A setToActions(int index,Action item){
            if (this.actions == null) {this.actions = new ArrayList<ActionBuilder>();}
            ActionBuilder builder = new ActionBuilder(item);
            if (index < 0 || index >= _visitables.size()) { _visitables.add(builder); } else { _visitables.set(index, builder);}
            if (index < 0 || index >= actions.size()) { actions.add(builder); } else { actions.set(index, builder);}
             return (A)this;
    }

    public A addToActions(Action... items){
            if (this.actions == null) {this.actions = new ArrayList<ActionBuilder>();}
            for (Action item : items) {ActionBuilder builder = new ActionBuilder(item);_visitables.add(builder);this.actions.add(builder);} return (A)this;
    }

    public A addAllToActions(Collection<Action> items){
            if (this.actions == null) {this.actions = new ArrayList<ActionBuilder>();}
            for (Action item : items) {ActionBuilder builder = new ActionBuilder(item);_visitables.add(builder);this.actions.add(builder);} return (A)this;
    }

    public A removeFromActions(Action... items){
            for (Action item : items) {ActionBuilder builder = new ActionBuilder(item);_visitables.remove(builder);if (this.actions != null) {this.actions.remove(builder);}} return (A)this;
    }

    public A removeAllFromActions(Collection<Action> items){
            for (Action item : items) {ActionBuilder builder = new ActionBuilder(item);_visitables.remove(builder);if (this.actions != null) {this.actions.remove(builder);}} return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildActions instead.
 * @return The buildable object.
 */
@Deprecated public List<Action> getActions(){
            return build(actions);
    }

    public List<Action> buildActions(){
            return build(actions);
    }

    public Action buildAction(int index){
            return this.actions.get(index).build();
    }

    public Action buildFirstAction(){
            return this.actions.get(0).build();
    }

    public Action buildLastAction(){
            return this.actions.get(actions.size() - 1).build();
    }

    public Action buildMatchingAction(io.fabric8.kubernetes.api.builder.Predicate<ActionBuilder> predicate){
            for (ActionBuilder item: actions) { if(predicate.apply(item)){return item.build();} } return null;
    }

    public A withActions(List<Action> actions){
            if (this.actions != null) { _visitables.removeAll(this.actions);}
            if (actions != null) {this.actions = new ArrayList<ActionBuilder>(); for (Action item : actions){this.addToActions(item);}} else { this.actions = null;} return (A) this;
    }

    public A withActions(Action... actions){
            if (this.actions != null) {this.actions.clear();}
            if (actions != null) {for (Action item :actions){ this.addToActions(item);}} return (A) this;
    }

    public Boolean hasActions(){
            return actions != null && !actions.isEmpty();
    }

    public RuleSpecFluent.ActionsNested<A> addNewAction(){
            return new ActionsNestedImpl();
    }

    public RuleSpecFluent.ActionsNested<A> addNewActionLike(Action item){
            return new ActionsNestedImpl(-1, item);
    }

    public RuleSpecFluent.ActionsNested<A> setNewActionLike(int index,Action item){
            return new ActionsNestedImpl(index, item);
    }

    public RuleSpecFluent.ActionsNested<A> editAction(int index){
            if (actions.size() <= index) throw new RuntimeException("Can't edit actions. Index exceeds size.");
            return setNewActionLike(index, buildAction(index));
    }

    public RuleSpecFluent.ActionsNested<A> editFirstAction(){
            if (actions.size() == 0) throw new RuntimeException("Can't edit first actions. The list is empty.");
            return setNewActionLike(0, buildAction(0));
    }

    public RuleSpecFluent.ActionsNested<A> editLastAction(){
            int index = actions.size() - 1;
            if (index < 0) throw new RuntimeException("Can't edit last actions. The list is empty.");
            return setNewActionLike(index, buildAction(index));
    }

    public RuleSpecFluent.ActionsNested<A> editMatchingAction(io.fabric8.kubernetes.api.builder.Predicate<ActionBuilder> predicate){
            int index = -1;
            for (int i=0;i<actions.size();i++) { 
            if (predicate.apply(actions.get(i))) {index = i; break;}
            } 
            if (index < 0) throw new RuntimeException("Can't edit matching actions. No match found.");
            return setNewActionLike(index, buildAction(index));
    }

    public String getMatch(){
            return this.match;
    }

    public A withMatch(String match){
            this.match=match; return (A) this;
    }

    public Boolean hasMatch(){
            return this.match != null;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            RuleSpecFluentImpl that = (RuleSpecFluentImpl) o;
            if (actions != null ? !actions.equals(that.actions) :that.actions != null) return false;
            if (match != null ? !match.equals(that.match) :that.match != null) return false;
            return true;
    }


    public class ActionsNestedImpl<N> extends ActionFluentImpl<RuleSpecFluent.ActionsNested<N>> implements RuleSpecFluent.ActionsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final ActionBuilder builder;
        private final int index;
    
            ActionsNestedImpl(int index,Action item){
                    this.index = index;
                    this.builder = new ActionBuilder(this, item);
            }
            ActionsNestedImpl(){
                    this.index = -1;
                    this.builder = new ActionBuilder(this);
            }
    
    public N and(){
            return (N) RuleSpecFluentImpl.this.setToActions(index, builder.build());
    }
    public N endAction(){
            return and();
    }

}


}
