
package me.snowdrop.istio.api.rbac.v1alpha1;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.validation.Valid;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.fabric8.kubernetes.api.model.Doneable;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.BuildableReference;
import io.sundr.builder.annotations.Inline;
import lombok.EqualsAndHashCode;
import lombok.ToString;


/**
 * 
 * 
 */
@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder({
    "apiVersion",
    "kind",
    "metadata",
    "constraints",
    "methods",
    "paths",
    "services"
})
@ToString
@EqualsAndHashCode
@Buildable(editableEnabled = false, validationEnabled = true, generateBuilderPackage = true, builderPackage = "io.fabric8.kubernetes.api.builder", inline = {
    @Inline(type = Doneable.class, prefix = "Doneable", value = "done")
}, refs = {
    @BuildableReference(ObjectMeta.class)
})
public class AccessRule implements Serializable
{

    /**
     * 
     * 
     */
    @JsonProperty("constraints")
    @JsonPropertyDescription("")
    @Valid
    private List<Constraint> constraints = new ArrayList<Constraint>();
    /**
     * 
     * 
     */
    @JsonProperty("methods")
    @JsonPropertyDescription("")
    @Valid
    private List<String> methods = new ArrayList<String>();
    /**
     * 
     * 
     */
    @JsonProperty("paths")
    @JsonPropertyDescription("")
    @Valid
    private List<String> paths = new ArrayList<String>();
    /**
     * 
     * 
     */
    @JsonProperty("services")
    @JsonPropertyDescription("")
    @Valid
    private List<String> services = new ArrayList<String>();
    private final static long serialVersionUID = -8937449611973441802L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public AccessRule() {
    }

    /**
     * 
     * @param methods
     * @param paths
     * @param services
     * @param constraints
     */
    public AccessRule(List<Constraint> constraints, List<String> methods, List<String> paths, List<String> services) {
        super();
        this.constraints = constraints;
        this.methods = methods;
        this.paths = paths;
        this.services = services;
    }

    /**
     * 
     * 
     */
    @JsonProperty("constraints")
    public List<Constraint> getConstraints() {
        return constraints;
    }

    /**
     * 
     * 
     */
    @JsonProperty("constraints")
    public void setConstraints(List<Constraint> constraints) {
        this.constraints = constraints;
    }

    /**
     * 
     * 
     */
    @JsonProperty("methods")
    public List<String> getMethods() {
        return methods;
    }

    /**
     * 
     * 
     */
    @JsonProperty("methods")
    public void setMethods(List<String> methods) {
        this.methods = methods;
    }

    /**
     * 
     * 
     */
    @JsonProperty("paths")
    public List<String> getPaths() {
        return paths;
    }

    /**
     * 
     * 
     */
    @JsonProperty("paths")
    public void setPaths(List<String> paths) {
        this.paths = paths;
    }

    /**
     * 
     * 
     */
    @JsonProperty("services")
    public List<String> getServices() {
        return services;
    }

    /**
     * 
     * 
     */
    @JsonProperty("services")
    public void setServices(List<String> services) {
        this.services = services;
    }

}
