package me.snowdrop.istio.api.rbac.v1alpha1;

import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import javax.validation.constraints.NotNull;
import io.fabric8.kubernetes.api.builder.Predicate;
import io.fabric8.kubernetes.api.model.ListMeta;
import java.lang.Deprecated;
import javax.validation.Valid;
import java.util.Collection;
import java.util.List;
import java.lang.Boolean;

public interface ServiceRoleBindingListFluent<A extends ServiceRoleBindingListFluent<A>> extends Fluent<A>{


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public Boolean hasApiVersion();
    public A addToItems(int index,ServiceRoleBinding item);
    public A setToItems(int index,ServiceRoleBinding item);
    public A addToItems(ServiceRoleBinding... items);
    public A addAllToItems(Collection<ServiceRoleBinding> items);
    public A removeFromItems(ServiceRoleBinding... items);
    public A removeAllFromItems(Collection<ServiceRoleBinding> items);
    
/**
 * This method has been deprecated, please use method buildItems instead.
 * @return The buildable object.
 */
@Deprecated public List<ServiceRoleBinding> getItems();
    public List<ServiceRoleBinding> buildItems();
    public ServiceRoleBinding buildItem(int index);
    public ServiceRoleBinding buildFirstItem();
    public ServiceRoleBinding buildLastItem();
    public ServiceRoleBinding buildMatchingItem(Predicate<ServiceRoleBindingBuilder> predicate);
    public A withItems(List<ServiceRoleBinding> items);
    public A withItems(ServiceRoleBinding... items);
    public Boolean hasItems();
    public ServiceRoleBindingListFluent.ItemsNested<A> addNewItem();
    public ServiceRoleBindingListFluent.ItemsNested<A> addNewItemLike(ServiceRoleBinding item);
    public ServiceRoleBindingListFluent.ItemsNested<A> setNewItemLike(int index,ServiceRoleBinding item);
    public ServiceRoleBindingListFluent.ItemsNested<A> editItem(int index);
    public ServiceRoleBindingListFluent.ItemsNested<A> editFirstItem();
    public ServiceRoleBindingListFluent.ItemsNested<A> editLastItem();
    public ServiceRoleBindingListFluent.ItemsNested<A> editMatchingItem(Predicate<ServiceRoleBindingBuilder> predicate);
    public String getKind();
    public A withKind(String kind);
    public Boolean hasKind();
    public ListMeta getMetadata();
    public A withMetadata(ListMeta metadata);
    public Boolean hasMetadata();
    public A withNewMetadata(String _continue,String resourceVersion,String selfLink);

    public interface ItemsNested<N> extends Nested<N>,ServiceRoleBindingFluent<ServiceRoleBindingListFluent.ItemsNested<N>>{

        
    public N and();    public N endItem();
}


}
