
package me.snowdrop.istio.api.rbac.v1alpha1;

import java.io.Serializable;
import java.util.Map;
import javax.validation.Valid;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.fabric8.kubernetes.api.model.Doneable;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.BuildableReference;
import io.sundr.builder.annotations.Inline;
import lombok.EqualsAndHashCode;
import lombok.ToString;


/**
 * 
 * 
 */
@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder({
    "apiVersion",
    "kind",
    "metadata",
    "group",
    "properties",
    "user"
})
@ToString
@EqualsAndHashCode
@Buildable(editableEnabled = false, validationEnabled = true, generateBuilderPackage = true, builderPackage = "io.fabric8.kubernetes.api.builder", inline = {
    @Inline(type = Doneable.class, prefix = "Doneable", value = "done")
}, refs = {
    @BuildableReference(ObjectMeta.class)
})
public class Subject implements Serializable
{

    /**
     * 
     * 
     */
    @JsonProperty("group")
    @JsonPropertyDescription("")
    private java.lang.String group;
    /**
     * 
     * 
     */
    @JsonProperty("properties")
    @JsonPropertyDescription("")
    @Valid
    private Map<String, String> properties;
    /**
     * 
     * 
     */
    @JsonProperty("user")
    @JsonPropertyDescription("")
    private java.lang.String user;
    private final static long serialVersionUID = -2440693190337673763L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public Subject() {
    }

    /**
     * 
     * @param user
     * @param properties
     * @param group
     */
    public Subject(java.lang.String group, Map<String, String> properties, java.lang.String user) {
        super();
        this.group = group;
        this.properties = properties;
        this.user = user;
    }

    /**
     * 
     * 
     */
    @JsonProperty("group")
    public java.lang.String getGroup() {
        return group;
    }

    /**
     * 
     * 
     */
    @JsonProperty("group")
    public void setGroup(java.lang.String group) {
        this.group = group;
    }

    /**
     * 
     * 
     */
    @JsonProperty("properties")
    public Map<String, String> getProperties() {
        return properties;
    }

    /**
     * 
     * 
     */
    @JsonProperty("properties")
    public void setProperties(Map<String, String> properties) {
        this.properties = properties;
    }

    /**
     * 
     * 
     */
    @JsonProperty("user")
    public java.lang.String getUser() {
        return user;
    }

    /**
     * 
     * 
     */
    @JsonProperty("user")
    public void setUser(java.lang.String user) {
        this.user = user;
    }

}
