
package me.snowdrop.istio.mixer.adapter.circonus;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.validation.Valid;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.fabric8.kubernetes.api.model.Doneable;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.BuildableReference;
import io.sundr.builder.annotations.Inline;
import io.sundr.transform.annotations.VelocityTransformation;
import io.sundr.transform.annotations.VelocityTransformations;
import lombok.EqualsAndHashCode;
import lombok.ToString;
import me.snowdrop.istio.api.IstioSpec;
import me.snowdrop.istio.api.internal.IstioApiVersion;
import me.snowdrop.istio.api.internal.IstioKind;


/**
 * 
 * 
 */
@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder({
    "apiVersion",
    "kind",
    "metadata",
    "metrics",
    "submissionInterval",
    "submissionUrl"
})
@IstioKind(name = "circonus", plural = "circonuses")
@IstioApiVersion("config.istio.io/v1alpha2")
@ToString
@EqualsAndHashCode
@Buildable(editableEnabled = false, validationEnabled = true, generateBuilderPackage = true, builderPackage = "io.fabric8.kubernetes.api.builder", inline = {
    @Inline(type = Doneable.class, prefix = "Doneable", value = "done")
}, refs = {
    @BuildableReference(ObjectMeta.class)
})
@VelocityTransformations({
    @VelocityTransformation("/istio-resource.vm"),
    @VelocityTransformation("/istio-resource-list.vm"),
    @VelocityTransformation(value = "/istio-manifest.vm", outputPath = "crd.properties", gather = true),
    @VelocityTransformation(value = "/istio-mappings-provider.vm", outputPath = "me/snowdrop/istio/api/model/IstioResourceMappingsProvider.java", gather = true)
})
public class CirconusSpec implements Serializable, IstioSpec
{

    /**
     * 
     * 
     */
    @JsonProperty("metrics")
    @JsonPropertyDescription("")
    @Valid
    private List<MetricInfo> metrics = new ArrayList<MetricInfo>();
    /**
     * 
     * 
     */
    @JsonProperty("submissionInterval")
    @JsonPropertyDescription("")
    private Long submissionInterval;
    /**
     * 
     * 
     */
    @JsonProperty("submissionUrl")
    @JsonPropertyDescription("")
    private String submissionUrl;
    private final static long serialVersionUID = 2454805615999279957L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public CirconusSpec() {
    }

    /**
     * 
     * @param submissionInterval
     * @param metrics
     * @param submissionUrl
     */
    public CirconusSpec(List<MetricInfo> metrics, Long submissionInterval, String submissionUrl) {
        super();
        this.metrics = metrics;
        this.submissionInterval = submissionInterval;
        this.submissionUrl = submissionUrl;
    }

    /**
     * 
     * 
     */
    @JsonProperty("metrics")
    public List<MetricInfo> getMetrics() {
        return metrics;
    }

    /**
     * 
     * 
     */
    @JsonProperty("metrics")
    public void setMetrics(List<MetricInfo> metrics) {
        this.metrics = metrics;
    }

    /**
     * 
     * 
     */
    @JsonProperty("submissionInterval")
    public Long getSubmissionInterval() {
        return submissionInterval;
    }

    /**
     * 
     * 
     */
    @JsonProperty("submissionInterval")
    public void setSubmissionInterval(Long submissionInterval) {
        this.submissionInterval = submissionInterval;
    }

    /**
     * 
     * 
     */
    @JsonProperty("submissionUrl")
    public String getSubmissionUrl() {
        return submissionUrl;
    }

    /**
     * 
     * 
     */
    @JsonProperty("submissionUrl")
    public void setSubmissionUrl(String submissionUrl) {
        this.submissionUrl = submissionUrl;
    }

}
