package me.snowdrop.istio.mixer.adapter.circonus;

import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.builder.Predicate;
import java.lang.Deprecated;
import javax.validation.Valid;
import java.lang.Long;
import java.util.Collection;
import java.util.List;
import java.lang.Boolean;

public interface CirconusSpecFluent<A extends CirconusSpecFluent<A>> extends Fluent<A>{


    public A addToMetrics(int index,MetricInfo item);
    public A setToMetrics(int index,MetricInfo item);
    public A addToMetrics(MetricInfo... items);
    public A addAllToMetrics(Collection<MetricInfo> items);
    public A removeFromMetrics(MetricInfo... items);
    public A removeAllFromMetrics(Collection<MetricInfo> items);
    
/**
 * This method has been deprecated, please use method buildMetrics instead.
 * @return The buildable object.
 */
@Deprecated public List<MetricInfo> getMetrics();
    public List<MetricInfo> buildMetrics();
    public MetricInfo buildMetric(int index);
    public MetricInfo buildFirstMetric();
    public MetricInfo buildLastMetric();
    public MetricInfo buildMatchingMetric(io.fabric8.kubernetes.api.builder.Predicate<MetricInfoBuilder> predicate);
    public A withMetrics(List<MetricInfo> metrics);
    public A withMetrics(MetricInfo... metrics);
    public Boolean hasMetrics();
    public CirconusSpecFluent.MetricsNested<A> addNewMetric();
    public CirconusSpecFluent.MetricsNested<A> addNewMetricLike(MetricInfo item);
    public CirconusSpecFluent.MetricsNested<A> setNewMetricLike(int index,MetricInfo item);
    public CirconusSpecFluent.MetricsNested<A> editMetric(int index);
    public CirconusSpecFluent.MetricsNested<A> editFirstMetric();
    public CirconusSpecFluent.MetricsNested<A> editLastMetric();
    public CirconusSpecFluent.MetricsNested<A> editMatchingMetric(io.fabric8.kubernetes.api.builder.Predicate<MetricInfoBuilder> predicate);
    public Long getSubmissionInterval();
    public A withSubmissionInterval(Long submissionInterval);
    public Boolean hasSubmissionInterval();
    public A withNewSubmissionInterval(String arg1);
    public A withNewSubmissionInterval(long arg1);
    public String getSubmissionUrl();
    public A withSubmissionUrl(String submissionUrl);
    public Boolean hasSubmissionUrl();

    public interface MetricsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,MetricInfoFluent<CirconusSpecFluent.MetricsNested<N>>{

        
    public N and();    public N endMetric();
}


}
