package me.snowdrop.istio.mixer.adapter.memquota;

import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.String;
import java.util.LinkedHashMap;
import javax.validation.Valid;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Long;
import java.lang.Object;
import java.lang.Boolean;
import java.util.Map;

public class OverrideFluentImpl<A extends OverrideFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements OverrideFluent<A>{

    private Map<String,String> dimensions;
    private Long maxAmount;
    private Long validDuration;

    public OverrideFluentImpl(){
    }
    public OverrideFluentImpl(me.snowdrop.istio.mixer.adapter.memquota.Override instance){
            this.withDimensions(instance.getDimensions()); 
            this.withMaxAmount(instance.getMaxAmount()); 
            this.withValidDuration(instance.getValidDuration()); 
    }

    public A addToDimensions(String key,String value){
            if(this.dimensions == null && key != null && value != null) { this.dimensions = new LinkedHashMap<String,String>(); }
            if(key != null && value != null) {this.dimensions.put(key, value);} return (A)this;
    }

    public A addToDimensions(Map<String,String> map){
            if(this.dimensions == null && map != null) { this.dimensions = new LinkedHashMap<String,String>(); }
            if(map != null) { this.dimensions.putAll(map);} return (A)this;
    }

    public A removeFromDimensions(String key){
            if(this.dimensions == null) { return (A) this; }
            if(key != null && this.dimensions != null) {this.dimensions.remove(key);} return (A)this;
    }

    public A removeFromDimensions(Map<String,String> map){
            if(this.dimensions == null) { return (A) this; }
            if(map != null) { for(Object key : map.keySet()) {if (this.dimensions != null){this.dimensions.remove(key);}}} return (A)this;
    }

    public Map<String,String> getDimensions(){
            return this.dimensions;
    }

    public A withDimensions(Map<String,String> dimensions){
            if (dimensions == null) { this.dimensions =  null;} else {this.dimensions = new LinkedHashMap<String,String>(dimensions);} return (A) this;
    }

    public Boolean hasDimensions(){
            return this.dimensions != null;
    }

    public Long getMaxAmount(){
            return this.maxAmount;
    }

    public A withMaxAmount(Long maxAmount){
            this.maxAmount=maxAmount; return (A) this;
    }

    public Boolean hasMaxAmount(){
            return this.maxAmount != null;
    }

    public A withNewMaxAmount(String arg1){
            return (A)withMaxAmount(new Long(arg1));
    }

    public A withNewMaxAmount(long arg1){
            return (A)withMaxAmount(new Long(arg1));
    }

    public Long getValidDuration(){
            return this.validDuration;
    }

    public A withValidDuration(Long validDuration){
            this.validDuration=validDuration; return (A) this;
    }

    public Boolean hasValidDuration(){
            return this.validDuration != null;
    }

    public A withNewValidDuration(String arg1){
            return (A)withValidDuration(new Long(arg1));
    }

    public A withNewValidDuration(long arg1){
            return (A)withValidDuration(new Long(arg1));
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            OverrideFluentImpl that = (OverrideFluentImpl) o;
            if (dimensions != null ? !dimensions.equals(that.dimensions) :that.dimensions != null) return false;
            if (maxAmount != null ? !maxAmount.equals(that.maxAmount) :that.maxAmount != null) return false;
            if (validDuration != null ? !validDuration.equals(that.validDuration) :that.validDuration != null) return false;
            return true;
    }




}
