
package me.snowdrop.istio.mixer.adapter.prometheus;

import java.io.Serializable;
import javax.validation.Valid;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.fabric8.kubernetes.api.model.Doneable;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.BuildableReference;
import io.sundr.builder.annotations.Inline;
import lombok.EqualsAndHashCode;
import lombok.ToString;
import me.snowdrop.istio.mixer.adapter.prometheus.BucketsDefinition.Definition;


/**
 * 
 * 
 */
@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder({
    "apiVersion",
    "kind",
    "metadata",
    "exponentialBuckets"
})
@ToString
@EqualsAndHashCode
@Buildable(editableEnabled = false, validationEnabled = true, generateBuilderPackage = true, builderPackage = "io.fabric8.kubernetes.api.builder", inline = {
    @Inline(type = Doneable.class, prefix = "Doneable", value = "done")
}, refs = {
    @BuildableReference(ObjectMeta.class)
})
public class ExponentialBucketsDefinition implements Serializable, Definition
{

    /**
     * 
     * 
     */
    @JsonProperty("exponentialBuckets")
    @JsonPropertyDescription("")
    @Valid
    private Exponential exponentialBuckets;
    private final static long serialVersionUID = -7355909194818359707L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public ExponentialBucketsDefinition() {
    }

    /**
     * 
     * @param exponentialBuckets
     */
    public ExponentialBucketsDefinition(Exponential exponentialBuckets) {
        super();
        this.exponentialBuckets = exponentialBuckets;
    }

    /**
     * 
     * 
     */
    @JsonProperty("exponentialBuckets")
    public Exponential getExponentialBuckets() {
        return exponentialBuckets;
    }

    /**
     * 
     * 
     */
    @JsonProperty("exponentialBuckets")
    public void setExponentialBuckets(Exponential exponentialBuckets) {
        this.exponentialBuckets = exponentialBuckets;
    }

}
