package me.snowdrop.istio.mixer.adapter.prometheus;

import java.lang.Integer;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.String;
import java.lang.Boolean;
import java.lang.Double;

public class ExponentialFluentImpl<A extends ExponentialFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements ExponentialFluent<A>{

    private Double growthFactor;
    private Integer numFiniteBuckets;
    private Double scale;

    public ExponentialFluentImpl(){
    }
    public ExponentialFluentImpl(Exponential instance){
            this.withGrowthFactor(instance.getGrowthFactor()); 
            this.withNumFiniteBuckets(instance.getNumFiniteBuckets()); 
            this.withScale(instance.getScale()); 
    }

    public Double getGrowthFactor(){
            return this.growthFactor;
    }

    public A withGrowthFactor(Double growthFactor){
            this.growthFactor=growthFactor; return (A) this;
    }

    public Boolean hasGrowthFactor(){
            return this.growthFactor != null;
    }

    public A withNewGrowthFactor(String arg1){
            return (A)withGrowthFactor(new Double(arg1));
    }

    public A withNewGrowthFactor(double arg1){
            return (A)withGrowthFactor(new Double(arg1));
    }

    public Integer getNumFiniteBuckets(){
            return this.numFiniteBuckets;
    }

    public A withNumFiniteBuckets(Integer numFiniteBuckets){
            this.numFiniteBuckets=numFiniteBuckets; return (A) this;
    }

    public Boolean hasNumFiniteBuckets(){
            return this.numFiniteBuckets != null;
    }

    public A withNewNumFiniteBuckets(String arg1){
            return (A)withNumFiniteBuckets(new Integer(arg1));
    }

    public A withNewNumFiniteBuckets(int arg1){
            return (A)withNumFiniteBuckets(new Integer(arg1));
    }

    public Double getScale(){
            return this.scale;
    }

    public A withScale(Double scale){
            this.scale=scale; return (A) this;
    }

    public Boolean hasScale(){
            return this.scale != null;
    }

    public A withNewScale(String arg1){
            return (A)withScale(new Double(arg1));
    }

    public A withNewScale(double arg1){
            return (A)withScale(new Double(arg1));
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            ExponentialFluentImpl that = (ExponentialFluentImpl) o;
            if (growthFactor != null ? !growthFactor.equals(that.growthFactor) :that.growthFactor != null) return false;
            if (numFiniteBuckets != null ? !numFiniteBuckets.equals(that.numFiniteBuckets) :that.numFiniteBuckets != null) return false;
            if (scale != null ? !scale.equals(that.scale) :that.scale != null) return false;
            return true;
    }




}
