
package me.snowdrop.istio.mixer.adapter.redisquota;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.validation.Valid;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.fabric8.kubernetes.api.model.Doneable;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.BuildableReference;
import io.sundr.builder.annotations.Inline;
import io.sundr.transform.annotations.VelocityTransformation;
import io.sundr.transform.annotations.VelocityTransformations;
import lombok.EqualsAndHashCode;
import lombok.ToString;
import me.snowdrop.istio.api.IstioSpec;
import me.snowdrop.istio.api.internal.IstioApiVersion;
import me.snowdrop.istio.api.internal.IstioKind;


/**
 * 
 * 
 */
@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder({
    "apiVersion",
    "kind",
    "metadata",
    "connectionPoolSize",
    "quotas",
    "redisServerUrl"
})
@IstioKind(name = "redisquota", plural = "redisquotas")
@IstioApiVersion("config.istio.io/v1alpha2")
@ToString
@EqualsAndHashCode
@Buildable(editableEnabled = false, validationEnabled = true, generateBuilderPackage = true, builderPackage = "io.fabric8.kubernetes.api.builder", inline = {
    @Inline(type = Doneable.class, prefix = "Doneable", value = "done")
}, refs = {
    @BuildableReference(ObjectMeta.class)
})
@VelocityTransformations({
    @VelocityTransformation("/istio-resource.vm"),
    @VelocityTransformation("/istio-resource-list.vm"),
    @VelocityTransformation(value = "/istio-manifest.vm", outputPath = "crd.properties", gather = true),
    @VelocityTransformation(value = "/istio-mappings-provider.vm", outputPath = "me/snowdrop/istio/api/model/IstioResourceMappingsProvider.java", gather = true)
})
public class RedisquotaSpec implements Serializable, IstioSpec
{

    /**
     * 
     * 
     */
    @JsonProperty("connectionPoolSize")
    @JsonPropertyDescription("")
    private Long connectionPoolSize;
    /**
     * 
     * 
     */
    @JsonProperty("quotas")
    @JsonPropertyDescription("")
    @Valid
    private List<Quota> quotas = new ArrayList<Quota>();
    /**
     * 
     * 
     */
    @JsonProperty("redisServerUrl")
    @JsonPropertyDescription("")
    private String redisServerUrl;
    private final static long serialVersionUID = 1354862416582163187L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public RedisquotaSpec() {
    }

    /**
     * 
     * @param quotas
     * @param redisServerUrl
     * @param connectionPoolSize
     */
    public RedisquotaSpec(Long connectionPoolSize, List<Quota> quotas, String redisServerUrl) {
        super();
        this.connectionPoolSize = connectionPoolSize;
        this.quotas = quotas;
        this.redisServerUrl = redisServerUrl;
    }

    /**
     * 
     * 
     */
    @JsonProperty("connectionPoolSize")
    public Long getConnectionPoolSize() {
        return connectionPoolSize;
    }

    /**
     * 
     * 
     */
    @JsonProperty("connectionPoolSize")
    public void setConnectionPoolSize(Long connectionPoolSize) {
        this.connectionPoolSize = connectionPoolSize;
    }

    /**
     * 
     * 
     */
    @JsonProperty("quotas")
    public List<Quota> getQuotas() {
        return quotas;
    }

    /**
     * 
     * 
     */
    @JsonProperty("quotas")
    public void setQuotas(List<Quota> quotas) {
        this.quotas = quotas;
    }

    /**
     * 
     * 
     */
    @JsonProperty("redisServerUrl")
    public String getRedisServerUrl() {
        return redisServerUrl;
    }

    /**
     * 
     * 
     */
    @JsonProperty("redisServerUrl")
    public void setRedisServerUrl(String redisServerUrl) {
        this.redisServerUrl = redisServerUrl;
    }

}
