package me.snowdrop.istio.mixer.adapter.servicecontrol;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
import javax.validation.Validator;

public class RuntimeConfigBuilder extends RuntimeConfigFluentImpl<RuntimeConfigBuilder> implements VisitableBuilder<RuntimeConfig,RuntimeConfigBuilder>{

    RuntimeConfigFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public RuntimeConfigBuilder(){
            this(true);
    }
    public RuntimeConfigBuilder(Boolean validationEnabled){
            this(new RuntimeConfig(), validationEnabled);
    }
    public RuntimeConfigBuilder(RuntimeConfigFluent<?> fluent){
            this(fluent, true);
    }
    public RuntimeConfigBuilder(RuntimeConfigFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new RuntimeConfig(), validationEnabled);
    }
    public RuntimeConfigBuilder(RuntimeConfigFluent<?> fluent,RuntimeConfig instance){
            this(fluent, instance, true);
    }
    public RuntimeConfigBuilder(RuntimeConfigFluent<?> fluent,RuntimeConfig instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withCheckCacheSize(instance.getCheckCacheSize()); 
            fluent.withCheckResultExpiration(instance.getCheckResultExpiration()); 
            this.validationEnabled = validationEnabled; 
    }
    public RuntimeConfigBuilder(RuntimeConfig instance){
            this(instance,true);
    }
    public RuntimeConfigBuilder(RuntimeConfig instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withCheckCacheSize(instance.getCheckCacheSize()); 
            this.withCheckResultExpiration(instance.getCheckResultExpiration()); 
            this.validationEnabled = validationEnabled; 
    }
    public RuntimeConfigBuilder(Validator validator){
            this(new RuntimeConfig(), true);
    }
    public RuntimeConfigBuilder(RuntimeConfigFluent<?> fluent,RuntimeConfig instance,Validator validator){
            this.fluent = fluent; 
            fluent.withCheckCacheSize(instance.getCheckCacheSize()); 
            fluent.withCheckResultExpiration(instance.getCheckResultExpiration()); 
            this.validator = validator;
            this.validationEnabled = validator != null; 
    }
    public RuntimeConfigBuilder(RuntimeConfig instance,Validator validator){
            this.fluent = this; 
            this.withCheckCacheSize(instance.getCheckCacheSize()); 
            this.withCheckResultExpiration(instance.getCheckResultExpiration()); 
            this.validator = validator; 
            this.validationEnabled = validator != null; 
    }

    public RuntimeConfig build(){
            RuntimeConfig buildable = new RuntimeConfig(fluent.getCheckCacheSize(),fluent.getCheckResultExpiration());
            if (validationEnabled) {io.fabric8.kubernetes.api.builder.ValidationUtils.validate(buildable);}
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            RuntimeConfigBuilder that = (RuntimeConfigBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
