package me.snowdrop.istio.mixer.adapter.servicecontrol;

import me.snowdrop.istio.api.DurationFluentImpl;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.Nested;
import com.fasterxml.jackson.databind.JsonSerializer;
import java.lang.String;
import com.fasterxml.jackson.databind.JsonDeserializer;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.SerializerProvider;
import java.lang.Boolean;
import java.lang.Override;
import com.fasterxml.jackson.core.JsonParser;
import me.snowdrop.istio.api.Duration;
import java.lang.Integer;
import javax.validation.Valid;
import java.lang.Long;
import java.lang.Object;
import me.snowdrop.istio.api.DurationBuilder;

public class RuntimeConfigFluentImpl<A extends RuntimeConfigFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements RuntimeConfigFluent<A>{

    private Integer checkCacheSize;
    private DurationBuilder checkResultExpiration;

    public RuntimeConfigFluentImpl(){
    }
    public RuntimeConfigFluentImpl(RuntimeConfig instance){
            this.withCheckCacheSize(instance.getCheckCacheSize()); 
            this.withCheckResultExpiration(instance.getCheckResultExpiration()); 
    }

    public Integer getCheckCacheSize(){
            return this.checkCacheSize;
    }

    public A withCheckCacheSize(Integer checkCacheSize){
            this.checkCacheSize=checkCacheSize; return (A) this;
    }

    public Boolean hasCheckCacheSize(){
            return this.checkCacheSize != null;
    }

    public A withNewCheckCacheSize(String arg1){
            return (A)withCheckCacheSize(new Integer(arg1));
    }

    public A withNewCheckCacheSize(int arg1){
            return (A)withCheckCacheSize(new Integer(arg1));
    }

    
/**
 * This method has been deprecated, please use method buildCheckResultExpiration instead.
 * @return The buildable object.
 */
@Deprecated public Duration getCheckResultExpiration(){
            return this.checkResultExpiration!=null?this.checkResultExpiration.build():null;
    }

    public Duration buildCheckResultExpiration(){
            return this.checkResultExpiration!=null?this.checkResultExpiration.build():null;
    }

    public A withCheckResultExpiration(Duration checkResultExpiration){
            _visitables.remove(this.checkResultExpiration);
            if (checkResultExpiration!=null){ this.checkResultExpiration= new DurationBuilder(checkResultExpiration); _visitables.add(this.checkResultExpiration);} return (A) this;
    }

    public Boolean hasCheckResultExpiration(){
            return this.checkResultExpiration != null;
    }

    public A withNewCheckResultExpiration(Integer nanos,Long seconds){
            return (A)withCheckResultExpiration(new Duration(nanos, seconds));
    }

    public RuntimeConfigFluent.CheckResultExpirationNested<A> withNewCheckResultExpiration(){
            return new CheckResultExpirationNestedImpl();
    }

    public RuntimeConfigFluent.CheckResultExpirationNested<A> withNewCheckResultExpirationLike(Duration item){
            return new CheckResultExpirationNestedImpl(item);
    }

    public RuntimeConfigFluent.CheckResultExpirationNested<A> editCheckResultExpiration(){
            return withNewCheckResultExpirationLike(getCheckResultExpiration());
    }

    public RuntimeConfigFluent.CheckResultExpirationNested<A> editOrNewCheckResultExpiration(){
            return withNewCheckResultExpirationLike(getCheckResultExpiration() != null ? getCheckResultExpiration(): new DurationBuilder().build());
    }

    public RuntimeConfigFluent.CheckResultExpirationNested<A> editOrNewCheckResultExpirationLike(Duration item){
            return withNewCheckResultExpirationLike(getCheckResultExpiration() != null ? getCheckResultExpiration(): item);
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            RuntimeConfigFluentImpl that = (RuntimeConfigFluentImpl) o;
            if (checkCacheSize != null ? !checkCacheSize.equals(that.checkCacheSize) :that.checkCacheSize != null) return false;
            if (checkResultExpiration != null ? !checkResultExpiration.equals(that.checkResultExpiration) :that.checkResultExpiration != null) return false;
            return true;
    }


    public class CheckResultExpirationNestedImpl<N> extends DurationFluentImpl<RuntimeConfigFluent.CheckResultExpirationNested<N>> implements RuntimeConfigFluent.CheckResultExpirationNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final DurationBuilder builder;
    
            CheckResultExpirationNestedImpl(Duration item){
                    this.builder = new DurationBuilder(this, item);
            }
            CheckResultExpirationNestedImpl(){
                    this.builder = new DurationBuilder(this);
            }
    
    public N and(){
            return (N) RuntimeConfigFluentImpl.this.withCheckResultExpiration(builder.build());
    }
    public N endCheckResultExpiration(){
            return and();
    }

}


}
