package me.snowdrop.istio.mixer.adapter.signalfx;

import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.builder.Predicate;
import java.lang.Deprecated;
import javax.validation.Valid;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Long;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;

public class SignalfxSpecFluentImpl<A extends SignalfxSpecFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements SignalfxSpecFluent<A>{

    private String accessToken;
    private Long datapointInterval;
    private String ingestUrl;
    private List<MetricConfigBuilder> metrics;

    public SignalfxSpecFluentImpl(){
    }
    public SignalfxSpecFluentImpl(SignalfxSpec instance){
            this.withAccessToken(instance.getAccessToken()); 
            this.withDatapointInterval(instance.getDatapointInterval()); 
            this.withIngestUrl(instance.getIngestUrl()); 
            this.withMetrics(instance.getMetrics()); 
    }

    public String getAccessToken(){
            return this.accessToken;
    }

    public A withAccessToken(String accessToken){
            this.accessToken=accessToken; return (A) this;
    }

    public Boolean hasAccessToken(){
            return this.accessToken != null;
    }

    public Long getDatapointInterval(){
            return this.datapointInterval;
    }

    public A withDatapointInterval(Long datapointInterval){
            this.datapointInterval=datapointInterval; return (A) this;
    }

    public Boolean hasDatapointInterval(){
            return this.datapointInterval != null;
    }

    public A withNewDatapointInterval(String arg1){
            return (A)withDatapointInterval(new Long(arg1));
    }

    public A withNewDatapointInterval(long arg1){
            return (A)withDatapointInterval(new Long(arg1));
    }

    public String getIngestUrl(){
            return this.ingestUrl;
    }

    public A withIngestUrl(String ingestUrl){
            this.ingestUrl=ingestUrl; return (A) this;
    }

    public Boolean hasIngestUrl(){
            return this.ingestUrl != null;
    }

    public A addToMetrics(int index,MetricConfig item){
            if (this.metrics == null) {this.metrics = new ArrayList<MetricConfigBuilder>();}
            MetricConfigBuilder builder = new MetricConfigBuilder(item);_visitables.add(index >= 0 ? index : _visitables.size(), builder);this.metrics.add(index >= 0 ? index : metrics.size(), builder); return (A)this;
    }

    public A setToMetrics(int index,MetricConfig item){
            if (this.metrics == null) {this.metrics = new ArrayList<MetricConfigBuilder>();}
            MetricConfigBuilder builder = new MetricConfigBuilder(item);
            if (index < 0 || index >= _visitables.size()) { _visitables.add(builder); } else { _visitables.set(index, builder);}
            if (index < 0 || index >= metrics.size()) { metrics.add(builder); } else { metrics.set(index, builder);}
             return (A)this;
    }

    public A addToMetrics(MetricConfig... items){
            if (this.metrics == null) {this.metrics = new ArrayList<MetricConfigBuilder>();}
            for (MetricConfig item : items) {MetricConfigBuilder builder = new MetricConfigBuilder(item);_visitables.add(builder);this.metrics.add(builder);} return (A)this;
    }

    public A addAllToMetrics(Collection<MetricConfig> items){
            if (this.metrics == null) {this.metrics = new ArrayList<MetricConfigBuilder>();}
            for (MetricConfig item : items) {MetricConfigBuilder builder = new MetricConfigBuilder(item);_visitables.add(builder);this.metrics.add(builder);} return (A)this;
    }

    public A removeFromMetrics(MetricConfig... items){
            for (MetricConfig item : items) {MetricConfigBuilder builder = new MetricConfigBuilder(item);_visitables.remove(builder);if (this.metrics != null) {this.metrics.remove(builder);}} return (A)this;
    }

    public A removeAllFromMetrics(Collection<MetricConfig> items){
            for (MetricConfig item : items) {MetricConfigBuilder builder = new MetricConfigBuilder(item);_visitables.remove(builder);if (this.metrics != null) {this.metrics.remove(builder);}} return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildMetrics instead.
 * @return The buildable object.
 */
@Deprecated public List<MetricConfig> getMetrics(){
            return build(metrics);
    }

    public List<MetricConfig> buildMetrics(){
            return build(metrics);
    }

    public MetricConfig buildMetric(int index){
            return this.metrics.get(index).build();
    }

    public MetricConfig buildFirstMetric(){
            return this.metrics.get(0).build();
    }

    public MetricConfig buildLastMetric(){
            return this.metrics.get(metrics.size() - 1).build();
    }

    public MetricConfig buildMatchingMetric(io.fabric8.kubernetes.api.builder.Predicate<MetricConfigBuilder> predicate){
            for (MetricConfigBuilder item: metrics) { if(predicate.apply(item)){return item.build();} } return null;
    }

    public A withMetrics(List<MetricConfig> metrics){
            if (this.metrics != null) { _visitables.removeAll(this.metrics);}
            if (metrics != null) {this.metrics = new ArrayList<MetricConfigBuilder>(); for (MetricConfig item : metrics){this.addToMetrics(item);}} else { this.metrics = null;} return (A) this;
    }

    public A withMetrics(MetricConfig... metrics){
            if (this.metrics != null) {this.metrics.clear();}
            if (metrics != null) {for (MetricConfig item :metrics){ this.addToMetrics(item);}} return (A) this;
    }

    public Boolean hasMetrics(){
            return metrics != null && !metrics.isEmpty();
    }

    public SignalfxSpecFluent.MetricsNested<A> addNewMetric(){
            return new MetricsNestedImpl();
    }

    public SignalfxSpecFluent.MetricsNested<A> addNewMetricLike(MetricConfig item){
            return new MetricsNestedImpl(-1, item);
    }

    public SignalfxSpecFluent.MetricsNested<A> setNewMetricLike(int index,MetricConfig item){
            return new MetricsNestedImpl(index, item);
    }

    public SignalfxSpecFluent.MetricsNested<A> editMetric(int index){
            if (metrics.size() <= index) throw new RuntimeException("Can't edit metrics. Index exceeds size.");
            return setNewMetricLike(index, buildMetric(index));
    }

    public SignalfxSpecFluent.MetricsNested<A> editFirstMetric(){
            if (metrics.size() == 0) throw new RuntimeException("Can't edit first metrics. The list is empty.");
            return setNewMetricLike(0, buildMetric(0));
    }

    public SignalfxSpecFluent.MetricsNested<A> editLastMetric(){
            int index = metrics.size() - 1;
            if (index < 0) throw new RuntimeException("Can't edit last metrics. The list is empty.");
            return setNewMetricLike(index, buildMetric(index));
    }

    public SignalfxSpecFluent.MetricsNested<A> editMatchingMetric(io.fabric8.kubernetes.api.builder.Predicate<MetricConfigBuilder> predicate){
            int index = -1;
            for (int i=0;i<metrics.size();i++) { 
            if (predicate.apply(metrics.get(i))) {index = i; break;}
            } 
            if (index < 0) throw new RuntimeException("Can't edit matching metrics. No match found.");
            return setNewMetricLike(index, buildMetric(index));
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            SignalfxSpecFluentImpl that = (SignalfxSpecFluentImpl) o;
            if (accessToken != null ? !accessToken.equals(that.accessToken) :that.accessToken != null) return false;
            if (datapointInterval != null ? !datapointInterval.equals(that.datapointInterval) :that.datapointInterval != null) return false;
            if (ingestUrl != null ? !ingestUrl.equals(that.ingestUrl) :that.ingestUrl != null) return false;
            if (metrics != null ? !metrics.equals(that.metrics) :that.metrics != null) return false;
            return true;
    }


    public class MetricsNestedImpl<N> extends MetricConfigFluentImpl<SignalfxSpecFluent.MetricsNested<N>> implements SignalfxSpecFluent.MetricsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final MetricConfigBuilder builder;
        private final int index;
    
            MetricsNestedImpl(int index,MetricConfig item){
                    this.index = index;
                    this.builder = new MetricConfigBuilder(this, item);
            }
            MetricsNestedImpl(){
                    this.index = -1;
                    this.builder = new MetricConfigBuilder(this);
            }
    
    public N and(){
            return (N) SignalfxSpecFluentImpl.this.setToMetrics(index, builder.build());
    }
    public N endMetric(){
            return and();
    }

}


}
