package me.snowdrop.istio.mixer.adapter.solarwinds;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
import javax.validation.Validator;

public class LogInfoBuilder extends LogInfoFluentImpl<LogInfoBuilder> implements VisitableBuilder<LogInfo,LogInfoBuilder>{

    LogInfoFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public LogInfoBuilder(){
            this(true);
    }
    public LogInfoBuilder(Boolean validationEnabled){
            this(new LogInfo(), validationEnabled);
    }
    public LogInfoBuilder(LogInfoFluent<?> fluent){
            this(fluent, true);
    }
    public LogInfoBuilder(LogInfoFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new LogInfo(), validationEnabled);
    }
    public LogInfoBuilder(LogInfoFluent<?> fluent,LogInfo instance){
            this(fluent, instance, true);
    }
    public LogInfoBuilder(LogInfoFluent<?> fluent,LogInfo instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withPayloadTemplate(instance.getPayloadTemplate()); 
            this.validationEnabled = validationEnabled; 
    }
    public LogInfoBuilder(LogInfo instance){
            this(instance,true);
    }
    public LogInfoBuilder(LogInfo instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withPayloadTemplate(instance.getPayloadTemplate()); 
            this.validationEnabled = validationEnabled; 
    }
    public LogInfoBuilder(Validator validator){
            this(new LogInfo(), true);
    }
    public LogInfoBuilder(LogInfoFluent<?> fluent,LogInfo instance,Validator validator){
            this.fluent = fluent; 
            fluent.withPayloadTemplate(instance.getPayloadTemplate()); 
            this.validator = validator;
            this.validationEnabled = validator != null; 
    }
    public LogInfoBuilder(LogInfo instance,Validator validator){
            this.fluent = this; 
            this.withPayloadTemplate(instance.getPayloadTemplate()); 
            this.validator = validator; 
            this.validationEnabled = validator != null; 
    }

    public LogInfo build(){
            LogInfo buildable = new LogInfo(fluent.getPayloadTemplate());
            if (validationEnabled) {io.fabric8.kubernetes.api.builder.ValidationUtils.validate(buildable);}
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            LogInfoBuilder that = (LogInfoBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
