package me.snowdrop.istio.mixer.adapter.solarwinds;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
import javax.validation.Validator;

public class SolarwindsListBuilder extends SolarwindsListFluentImpl<SolarwindsListBuilder> implements VisitableBuilder<SolarwindsList,SolarwindsListBuilder>{

    SolarwindsListFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public SolarwindsListBuilder(){
            this(true);
    }
    public SolarwindsListBuilder(Boolean validationEnabled){
            this(new SolarwindsList(), validationEnabled);
    }
    public SolarwindsListBuilder(SolarwindsListFluent<?> fluent){
            this(fluent, true);
    }
    public SolarwindsListBuilder(SolarwindsListFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new SolarwindsList(), validationEnabled);
    }
    public SolarwindsListBuilder(SolarwindsListFluent<?> fluent,SolarwindsList instance){
            this(fluent, instance, true);
    }
    public SolarwindsListBuilder(SolarwindsListFluent<?> fluent,SolarwindsList instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withApiVersion(instance.getApiVersion()); 
            fluent.withItems(instance.getItems()); 
            fluent.withKind(instance.getKind()); 
            fluent.withMetadata(instance.getMetadata()); 
            this.validationEnabled = validationEnabled; 
    }
    public SolarwindsListBuilder(SolarwindsList instance){
            this(instance,true);
    }
    public SolarwindsListBuilder(SolarwindsList instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withApiVersion(instance.getApiVersion()); 
            this.withItems(instance.getItems()); 
            this.withKind(instance.getKind()); 
            this.withMetadata(instance.getMetadata()); 
            this.validationEnabled = validationEnabled; 
    }
    public SolarwindsListBuilder(Validator validator){
            this(new SolarwindsList(), true);
    }
    public SolarwindsListBuilder(SolarwindsListFluent<?> fluent,SolarwindsList instance,Validator validator){
            this.fluent = fluent; 
            fluent.withApiVersion(instance.getApiVersion()); 
            fluent.withItems(instance.getItems()); 
            fluent.withKind(instance.getKind()); 
            fluent.withMetadata(instance.getMetadata()); 
            this.validator = validator;
            this.validationEnabled = validator != null; 
    }
    public SolarwindsListBuilder(SolarwindsList instance,Validator validator){
            this.fluent = this; 
            this.withApiVersion(instance.getApiVersion()); 
            this.withItems(instance.getItems()); 
            this.withKind(instance.getKind()); 
            this.withMetadata(instance.getMetadata()); 
            this.validator = validator; 
            this.validationEnabled = validator != null; 
    }

    public SolarwindsList build(){
            SolarwindsList buildable = new SolarwindsList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
            if (validationEnabled) {io.fabric8.kubernetes.api.builder.ValidationUtils.validate(buildable);}
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            SolarwindsListBuilder that = (SolarwindsListBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
