package me.snowdrop.istio.mixer.adapter.solarwinds;

import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import javax.validation.constraints.NotNull;
import io.fabric8.kubernetes.api.builder.Predicate;
import io.fabric8.kubernetes.api.model.ListMeta;
import java.lang.Deprecated;
import javax.validation.Valid;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;

public class SolarwindsListFluentImpl<A extends SolarwindsListFluent<A>> extends BaseFluent<A> implements SolarwindsListFluent<A>{

    private String apiVersion;
    private List<SolarwindsBuilder> items;
    private String kind;
    private ListMeta metadata;

    public SolarwindsListFluentImpl(){
    }
    public SolarwindsListFluentImpl(SolarwindsList instance){
            this.withApiVersion(instance.getApiVersion()); 
            this.withItems(instance.getItems()); 
            this.withKind(instance.getKind()); 
            this.withMetadata(instance.getMetadata()); 
    }

    public String getApiVersion(){
            return this.apiVersion;
    }

    public A withApiVersion(String apiVersion){
            this.apiVersion=apiVersion; return (A) this;
    }

    public Boolean hasApiVersion(){
            return this.apiVersion != null;
    }

    public A addToItems(int index,Solarwinds item){
            if (this.items == null) {this.items = new ArrayList<SolarwindsBuilder>();}
            SolarwindsBuilder builder = new SolarwindsBuilder(item);_visitables.add(index >= 0 ? index : _visitables.size(), builder);this.items.add(index >= 0 ? index : items.size(), builder); return (A)this;
    }

    public A setToItems(int index,Solarwinds item){
            if (this.items == null) {this.items = new ArrayList<SolarwindsBuilder>();}
            SolarwindsBuilder builder = new SolarwindsBuilder(item);
            if (index < 0 || index >= _visitables.size()) { _visitables.add(builder); } else { _visitables.set(index, builder);}
            if (index < 0 || index >= items.size()) { items.add(builder); } else { items.set(index, builder);}
             return (A)this;
    }

    public A addToItems(Solarwinds... items){
            if (this.items == null) {this.items = new ArrayList<SolarwindsBuilder>();}
            for (Solarwinds item : items) {SolarwindsBuilder builder = new SolarwindsBuilder(item);_visitables.add(builder);this.items.add(builder);} return (A)this;
    }

    public A addAllToItems(Collection<Solarwinds> items){
            if (this.items == null) {this.items = new ArrayList<SolarwindsBuilder>();}
            for (Solarwinds item : items) {SolarwindsBuilder builder = new SolarwindsBuilder(item);_visitables.add(builder);this.items.add(builder);} return (A)this;
    }

    public A removeFromItems(Solarwinds... items){
            for (Solarwinds item : items) {SolarwindsBuilder builder = new SolarwindsBuilder(item);_visitables.remove(builder);if (this.items != null) {this.items.remove(builder);}} return (A)this;
    }

    public A removeAllFromItems(Collection<Solarwinds> items){
            for (Solarwinds item : items) {SolarwindsBuilder builder = new SolarwindsBuilder(item);_visitables.remove(builder);if (this.items != null) {this.items.remove(builder);}} return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildItems instead.
 * @return The buildable object.
 */
@Deprecated public List<Solarwinds> getItems(){
            return build(items);
    }

    public List<Solarwinds> buildItems(){
            return build(items);
    }

    public Solarwinds buildItem(int index){
            return this.items.get(index).build();
    }

    public Solarwinds buildFirstItem(){
            return this.items.get(0).build();
    }

    public Solarwinds buildLastItem(){
            return this.items.get(items.size() - 1).build();
    }

    public Solarwinds buildMatchingItem(Predicate<SolarwindsBuilder> predicate){
            for (SolarwindsBuilder item: items) { if(predicate.apply(item)){return item.build();} } return null;
    }

    public A withItems(List<Solarwinds> items){
            if (this.items != null) { _visitables.removeAll(this.items);}
            if (items != null) {this.items = new ArrayList<SolarwindsBuilder>(); for (Solarwinds item : items){this.addToItems(item);}} else { this.items = null;} return (A) this;
    }

    public A withItems(Solarwinds... items){
            if (this.items != null) {this.items.clear();}
            if (items != null) {for (Solarwinds item :items){ this.addToItems(item);}} return (A) this;
    }

    public Boolean hasItems(){
            return items != null && !items.isEmpty();
    }

    public SolarwindsListFluent.ItemsNested<A> addNewItem(){
            return new ItemsNestedImpl();
    }

    public SolarwindsListFluent.ItemsNested<A> addNewItemLike(Solarwinds item){
            return new ItemsNestedImpl(-1, item);
    }

    public SolarwindsListFluent.ItemsNested<A> setNewItemLike(int index,Solarwinds item){
            return new ItemsNestedImpl(index, item);
    }

    public SolarwindsListFluent.ItemsNested<A> editItem(int index){
            if (items.size() <= index) throw new RuntimeException("Can't edit items. Index exceeds size.");
            return setNewItemLike(index, buildItem(index));
    }

    public SolarwindsListFluent.ItemsNested<A> editFirstItem(){
            if (items.size() == 0) throw new RuntimeException("Can't edit first items. The list is empty.");
            return setNewItemLike(0, buildItem(0));
    }

    public SolarwindsListFluent.ItemsNested<A> editLastItem(){
            int index = items.size() - 1;
            if (index < 0) throw new RuntimeException("Can't edit last items. The list is empty.");
            return setNewItemLike(index, buildItem(index));
    }

    public SolarwindsListFluent.ItemsNested<A> editMatchingItem(Predicate<SolarwindsBuilder> predicate){
            int index = -1;
            for (int i=0;i<items.size();i++) { 
            if (predicate.apply(items.get(i))) {index = i; break;}
            } 
            if (index < 0) throw new RuntimeException("Can't edit matching items. No match found.");
            return setNewItemLike(index, buildItem(index));
    }

    public String getKind(){
            return this.kind;
    }

    public A withKind(String kind){
            this.kind=kind; return (A) this;
    }

    public Boolean hasKind(){
            return this.kind != null;
    }

    public ListMeta getMetadata(){
            return this.metadata;
    }

    public A withMetadata(ListMeta metadata){
            this.metadata=metadata; return (A) this;
    }

    public Boolean hasMetadata(){
            return this.metadata != null;
    }

    public A withNewMetadata(String _continue,String resourceVersion,String selfLink){
            return (A)withMetadata(new ListMeta(_continue, resourceVersion, selfLink));
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            SolarwindsListFluentImpl that = (SolarwindsListFluentImpl) o;
            if (apiVersion != null ? !apiVersion.equals(that.apiVersion) :that.apiVersion != null) return false;
            if (items != null ? !items.equals(that.items) :that.items != null) return false;
            if (kind != null ? !kind.equals(that.kind) :that.kind != null) return false;
            if (metadata != null ? !metadata.equals(that.metadata) :that.metadata != null) return false;
            return true;
    }


    public class ItemsNestedImpl<N> extends SolarwindsFluentImpl<SolarwindsListFluent.ItemsNested<N>> implements SolarwindsListFluent.ItemsNested<N>,Nested<N>{

            private final SolarwindsBuilder builder;
        private final int index;
    
            ItemsNestedImpl(int index,Solarwinds item){
                    this.index = index;
                    this.builder = new SolarwindsBuilder(this, item);
            }
            ItemsNestedImpl(){
                    this.index = -1;
                    this.builder = new SolarwindsBuilder(this);
            }
    
    public N and(){
            return (N) SolarwindsListFluentImpl.this.setToItems(index, builder.build());
    }
    public N endItem(){
            return and();
    }

}


}
