
package me.snowdrop.istio.mixer.adapter.solarwinds;

import java.io.Serializable;
import java.util.Map;
import javax.validation.Valid;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.fabric8.kubernetes.api.model.Doneable;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.BuildableReference;
import io.sundr.builder.annotations.Inline;
import io.sundr.transform.annotations.VelocityTransformation;
import io.sundr.transform.annotations.VelocityTransformations;
import lombok.EqualsAndHashCode;
import lombok.ToString;
import me.snowdrop.istio.api.IstioSpec;
import me.snowdrop.istio.api.internal.IstioApiVersion;
import me.snowdrop.istio.api.internal.IstioKind;


/**
 * 
 * 
 */
@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder({
    "apiVersion",
    "kind",
    "metadata",
    "appopticsAccessToken",
    "appopticsBatchSize",
    "logs",
    "metrics",
    "papertrailLocalRetentionDuration",
    "papertrailUrl"
})
@IstioKind(name = "solarwinds", plural = "solarwindses")
@IstioApiVersion("config.istio.io/v1alpha2")
@ToString
@EqualsAndHashCode
@Buildable(editableEnabled = false, validationEnabled = true, generateBuilderPackage = true, builderPackage = "io.fabric8.kubernetes.api.builder", inline = {
    @Inline(type = Doneable.class, prefix = "Doneable", value = "done")
}, refs = {
    @BuildableReference(ObjectMeta.class)
})
@VelocityTransformations({
    @VelocityTransformation("/istio-resource.vm"),
    @VelocityTransformation("/istio-resource-list.vm"),
    @VelocityTransformation(value = "/istio-manifest.vm", outputPath = "crd.properties", gather = true),
    @VelocityTransformation(value = "/istio-mappings-provider.vm", outputPath = "me/snowdrop/istio/api/model/IstioResourceMappingsProvider.java", gather = true)
})
public class SolarwindsSpec implements Serializable, IstioSpec
{

    /**
     * 
     * 
     */
    @JsonProperty("appopticsAccessToken")
    @JsonPropertyDescription("")
    private java.lang.String appopticsAccessToken;
    /**
     * 
     * 
     */
    @JsonProperty("appopticsBatchSize")
    @JsonPropertyDescription("")
    private Integer appopticsBatchSize;
    /**
     * 
     * 
     */
    @JsonProperty("logs")
    @JsonPropertyDescription("")
    @Valid
    private Map<String, LogInfo> logs;
    /**
     * 
     * 
     */
    @JsonProperty("metrics")
    @JsonPropertyDescription("")
    @Valid
    private Map<String, MetricInfo> metrics;
    /**
     * 
     * 
     */
    @JsonProperty("papertrailLocalRetentionDuration")
    @JsonPropertyDescription("")
    private Long papertrailLocalRetentionDuration;
    /**
     * 
     * 
     */
    @JsonProperty("papertrailUrl")
    @JsonPropertyDescription("")
    private java.lang.String papertrailUrl;
    private final static long serialVersionUID = 6171713304581371151L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public SolarwindsSpec() {
    }

    /**
     * 
     * @param papertrailLocalRetentionDuration
     * @param appopticsAccessToken
     * @param papertrailUrl
     * @param metrics
     * @param appopticsBatchSize
     * @param logs
     */
    public SolarwindsSpec(java.lang.String appopticsAccessToken, Integer appopticsBatchSize, Map<String, LogInfo> logs, Map<String, MetricInfo> metrics, Long papertrailLocalRetentionDuration, java.lang.String papertrailUrl) {
        super();
        this.appopticsAccessToken = appopticsAccessToken;
        this.appopticsBatchSize = appopticsBatchSize;
        this.logs = logs;
        this.metrics = metrics;
        this.papertrailLocalRetentionDuration = papertrailLocalRetentionDuration;
        this.papertrailUrl = papertrailUrl;
    }

    /**
     * 
     * 
     */
    @JsonProperty("appopticsAccessToken")
    public java.lang.String getAppopticsAccessToken() {
        return appopticsAccessToken;
    }

    /**
     * 
     * 
     */
    @JsonProperty("appopticsAccessToken")
    public void setAppopticsAccessToken(java.lang.String appopticsAccessToken) {
        this.appopticsAccessToken = appopticsAccessToken;
    }

    /**
     * 
     * 
     */
    @JsonProperty("appopticsBatchSize")
    public Integer getAppopticsBatchSize() {
        return appopticsBatchSize;
    }

    /**
     * 
     * 
     */
    @JsonProperty("appopticsBatchSize")
    public void setAppopticsBatchSize(Integer appopticsBatchSize) {
        this.appopticsBatchSize = appopticsBatchSize;
    }

    /**
     * 
     * 
     */
    @JsonProperty("logs")
    public Map<String, LogInfo> getLogs() {
        return logs;
    }

    /**
     * 
     * 
     */
    @JsonProperty("logs")
    public void setLogs(Map<String, LogInfo> logs) {
        this.logs = logs;
    }

    /**
     * 
     * 
     */
    @JsonProperty("metrics")
    public Map<String, MetricInfo> getMetrics() {
        return metrics;
    }

    /**
     * 
     * 
     */
    @JsonProperty("metrics")
    public void setMetrics(Map<String, MetricInfo> metrics) {
        this.metrics = metrics;
    }

    /**
     * 
     * 
     */
    @JsonProperty("papertrailLocalRetentionDuration")
    public Long getPapertrailLocalRetentionDuration() {
        return papertrailLocalRetentionDuration;
    }

    /**
     * 
     * 
     */
    @JsonProperty("papertrailLocalRetentionDuration")
    public void setPapertrailLocalRetentionDuration(Long papertrailLocalRetentionDuration) {
        this.papertrailLocalRetentionDuration = papertrailLocalRetentionDuration;
    }

    /**
     * 
     * 
     */
    @JsonProperty("papertrailUrl")
    public java.lang.String getPapertrailUrl() {
        return papertrailUrl;
    }

    /**
     * 
     * 
     */
    @JsonProperty("papertrailUrl")
    public void setPapertrailUrl(java.lang.String papertrailUrl) {
        this.papertrailUrl = papertrailUrl;
    }

}
