
package me.snowdrop.istio.mixer.adapter.stackdriver;

import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.fabric8.kubernetes.api.model.Doneable;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.BuildableReference;
import io.sundr.builder.annotations.Inline;
import lombok.EqualsAndHashCode;
import lombok.ToString;
import me.snowdrop.istio.mixer.adapter.stackdriver.StackdriverSpec.Creds;


/**
 * 
 * 
 */
@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder({
    "apiVersion",
    "kind",
    "metadata",
    "appCredentials"
})
@ToString
@EqualsAndHashCode
@Buildable(editableEnabled = false, validationEnabled = true, generateBuilderPackage = true, builderPackage = "io.fabric8.kubernetes.api.builder", inline = {
    @Inline(type = Doneable.class, prefix = "Doneable", value = "done")
}, refs = {
    @BuildableReference(ObjectMeta.class)
})
public class AppCredentialsCreds implements Serializable, Creds
{

    /**
     * 
     * 
     */
    @JsonProperty("appCredentials")
    @JsonPropertyDescription("")
    private Boolean appCredentials;
    private final static long serialVersionUID = -6410542273508922053L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public AppCredentialsCreds() {
    }

    /**
     * 
     * @param appCredentials
     */
    public AppCredentialsCreds(Boolean appCredentials) {
        super();
        this.appCredentials = appCredentials;
    }

    /**
     * 
     * 
     */
    @JsonProperty("appCredentials")
    public Boolean getAppCredentials() {
        return appCredentials;
    }

    /**
     * 
     * 
     */
    @JsonProperty("appCredentials")
    public void setAppCredentials(Boolean appCredentials) {
        this.appCredentials = appCredentials;
    }

}
