
package me.snowdrop.istio.mixer.adapter.stackdriver;

import java.io.Serializable;
import javax.validation.Valid;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.fabric8.kubernetes.api.model.Doneable;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.BuildableReference;
import io.sundr.builder.annotations.Inline;
import lombok.EqualsAndHashCode;
import lombok.ToString;


/**
 * 
 * 
 */
@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder({
    "apiVersion",
    "kind",
    "metadata",
    "buckets",
    "metricType",
    "value"
})
@ToString
@EqualsAndHashCode
@Buildable(editableEnabled = false, validationEnabled = true, generateBuilderPackage = true, builderPackage = "io.fabric8.kubernetes.api.builder", inline = {
    @Inline(type = Doneable.class, prefix = "Doneable", value = "done")
}, refs = {
    @BuildableReference(ObjectMeta.class)
})
public class MetricInfo implements Serializable
{

    /**
     * 
     * 
     */
    @JsonProperty("buckets")
    @JsonPropertyDescription("")
    @Valid
    private BucketsDefinition buckets;
    @JsonProperty("kind")
    private MetricKind kind;
    /**
     * 
     * 
     */
    @JsonProperty("metricType")
    @JsonPropertyDescription("")
    private String metricType;
    @JsonProperty("value")
    private ValueType value;
    private final static long serialVersionUID = -5135530968962156505L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public MetricInfo() {
    }

    /**
     * 
     * @param metricType
     * @param kind
     * @param buckets
     * @param value
     */
    public MetricInfo(BucketsDefinition buckets, MetricKind kind, String metricType, ValueType value) {
        super();
        this.buckets = buckets;
        this.kind = kind;
        this.metricType = metricType;
        this.value = value;
    }

    /**
     * 
     * 
     */
    @JsonProperty("buckets")
    public BucketsDefinition getBuckets() {
        return buckets;
    }

    /**
     * 
     * 
     */
    @JsonProperty("buckets")
    public void setBuckets(BucketsDefinition buckets) {
        this.buckets = buckets;
    }

    @JsonProperty("kind")
    public MetricKind getKind() {
        return kind;
    }

    @JsonProperty("kind")
    public void setKind(MetricKind kind) {
        this.kind = kind;
    }

    /**
     * 
     * 
     */
    @JsonProperty("metricType")
    public String getMetricType() {
        return metricType;
    }

    /**
     * 
     * 
     */
    @JsonProperty("metricType")
    public void setMetricType(String metricType) {
        this.metricType = metricType;
    }

    @JsonProperty("value")
    public ValueType getValue() {
        return value;
    }

    @JsonProperty("value")
    public void setValue(ValueType value) {
        this.value = value;
    }

}
