
package me.snowdrop.istio.mixer.adapter.stackdriver;

import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.fabric8.kubernetes.api.model.Doneable;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.BuildableReference;
import io.sundr.builder.annotations.Inline;
import lombok.EqualsAndHashCode;
import lombok.ToString;


/**
 * 
 * 
 */
@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder({
    "apiVersion",
    "kind",
    "metadata",
    "UniqueWriterIdentity",
    "UpdateDestination",
    "UpdateFilter",
    "UpdateIncludeChildren",
    "destination",
    "filter",
    "id"
})
@ToString
@EqualsAndHashCode
@Buildable(editableEnabled = false, validationEnabled = true, generateBuilderPackage = true, builderPackage = "io.fabric8.kubernetes.api.builder", inline = {
    @Inline(type = Doneable.class, prefix = "Doneable", value = "done")
}, refs = {
    @BuildableReference(ObjectMeta.class)
})
public class SinkInfo implements Serializable
{

    /**
     * 
     * 
     */
    @JsonProperty("UniqueWriterIdentity")
    @JsonPropertyDescription("")
    private Boolean uniqueWriterIdentity;
    /**
     * 
     * 
     */
    @JsonProperty("UpdateDestination")
    @JsonPropertyDescription("")
    private Boolean updateDestination;
    /**
     * 
     * 
     */
    @JsonProperty("UpdateFilter")
    @JsonPropertyDescription("")
    private Boolean updateFilter;
    /**
     * 
     * 
     */
    @JsonProperty("UpdateIncludeChildren")
    @JsonPropertyDescription("")
    private Boolean updateIncludeChildren;
    /**
     * 
     * 
     */
    @JsonProperty("destination")
    @JsonPropertyDescription("")
    private String destination;
    /**
     * 
     * 
     */
    @JsonProperty("filter")
    @JsonPropertyDescription("")
    private String filter;
    /**
     * 
     * 
     */
    @JsonProperty("id")
    @JsonPropertyDescription("")
    private String id;
    private final static long serialVersionUID = -4170338256467215688L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public SinkInfo() {
    }

    /**
     * 
     * @param filter
     * @param updateDestination
     * @param uniqueWriterIdentity
     * @param destination
     * @param updateFilter
     * @param updateIncludeChildren
     * @param id
     */
    public SinkInfo(Boolean uniqueWriterIdentity, Boolean updateDestination, Boolean updateFilter, Boolean updateIncludeChildren, String destination, String filter, String id) {
        super();
        this.uniqueWriterIdentity = uniqueWriterIdentity;
        this.updateDestination = updateDestination;
        this.updateFilter = updateFilter;
        this.updateIncludeChildren = updateIncludeChildren;
        this.destination = destination;
        this.filter = filter;
        this.id = id;
    }

    /**
     * 
     * 
     */
    @JsonProperty("UniqueWriterIdentity")
    public Boolean getUniqueWriterIdentity() {
        return uniqueWriterIdentity;
    }

    /**
     * 
     * 
     */
    @JsonProperty("UniqueWriterIdentity")
    public void setUniqueWriterIdentity(Boolean uniqueWriterIdentity) {
        this.uniqueWriterIdentity = uniqueWriterIdentity;
    }

    /**
     * 
     * 
     */
    @JsonProperty("UpdateDestination")
    public Boolean getUpdateDestination() {
        return updateDestination;
    }

    /**
     * 
     * 
     */
    @JsonProperty("UpdateDestination")
    public void setUpdateDestination(Boolean updateDestination) {
        this.updateDestination = updateDestination;
    }

    /**
     * 
     * 
     */
    @JsonProperty("UpdateFilter")
    public Boolean getUpdateFilter() {
        return updateFilter;
    }

    /**
     * 
     * 
     */
    @JsonProperty("UpdateFilter")
    public void setUpdateFilter(Boolean updateFilter) {
        this.updateFilter = updateFilter;
    }

    /**
     * 
     * 
     */
    @JsonProperty("UpdateIncludeChildren")
    public Boolean getUpdateIncludeChildren() {
        return updateIncludeChildren;
    }

    /**
     * 
     * 
     */
    @JsonProperty("UpdateIncludeChildren")
    public void setUpdateIncludeChildren(Boolean updateIncludeChildren) {
        this.updateIncludeChildren = updateIncludeChildren;
    }

    /**
     * 
     * 
     */
    @JsonProperty("destination")
    public String getDestination() {
        return destination;
    }

    /**
     * 
     * 
     */
    @JsonProperty("destination")
    public void setDestination(String destination) {
        this.destination = destination;
    }

    /**
     * 
     * 
     */
    @JsonProperty("filter")
    public String getFilter() {
        return filter;
    }

    /**
     * 
     * 
     */
    @JsonProperty("filter")
    public void setFilter(String filter) {
        this.filter = filter;
    }

    /**
     * 
     * 
     */
    @JsonProperty("id")
    public String getId() {
        return id;
    }

    /**
     * 
     * 
     */
    @JsonProperty("id")
    public void setId(String id) {
        this.id = id;
    }

}
