package me.snowdrop.istio.mixer.adapter.stackdriver;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
import javax.validation.Validator;

public class StackdriverListBuilder extends StackdriverListFluentImpl<StackdriverListBuilder> implements VisitableBuilder<StackdriverList,StackdriverListBuilder>{

    StackdriverListFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public StackdriverListBuilder(){
            this(true);
    }
    public StackdriverListBuilder(Boolean validationEnabled){
            this(new StackdriverList(), validationEnabled);
    }
    public StackdriverListBuilder(StackdriverListFluent<?> fluent){
            this(fluent, true);
    }
    public StackdriverListBuilder(StackdriverListFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new StackdriverList(), validationEnabled);
    }
    public StackdriverListBuilder(StackdriverListFluent<?> fluent,StackdriverList instance){
            this(fluent, instance, true);
    }
    public StackdriverListBuilder(StackdriverListFluent<?> fluent,StackdriverList instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withApiVersion(instance.getApiVersion()); 
            fluent.withItems(instance.getItems()); 
            fluent.withKind(instance.getKind()); 
            fluent.withMetadata(instance.getMetadata()); 
            this.validationEnabled = validationEnabled; 
    }
    public StackdriverListBuilder(StackdriverList instance){
            this(instance,true);
    }
    public StackdriverListBuilder(StackdriverList instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withApiVersion(instance.getApiVersion()); 
            this.withItems(instance.getItems()); 
            this.withKind(instance.getKind()); 
            this.withMetadata(instance.getMetadata()); 
            this.validationEnabled = validationEnabled; 
    }
    public StackdriverListBuilder(Validator validator){
            this(new StackdriverList(), true);
    }
    public StackdriverListBuilder(StackdriverListFluent<?> fluent,StackdriverList instance,Validator validator){
            this.fluent = fluent; 
            fluent.withApiVersion(instance.getApiVersion()); 
            fluent.withItems(instance.getItems()); 
            fluent.withKind(instance.getKind()); 
            fluent.withMetadata(instance.getMetadata()); 
            this.validator = validator;
            this.validationEnabled = validator != null; 
    }
    public StackdriverListBuilder(StackdriverList instance,Validator validator){
            this.fluent = this; 
            this.withApiVersion(instance.getApiVersion()); 
            this.withItems(instance.getItems()); 
            this.withKind(instance.getKind()); 
            this.withMetadata(instance.getMetadata()); 
            this.validator = validator; 
            this.validationEnabled = validator != null; 
    }

    public StackdriverList build(){
            StackdriverList buildable = new StackdriverList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
            if (validationEnabled) {io.fabric8.kubernetes.api.builder.ValidationUtils.validate(buildable);}
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            StackdriverListBuilder that = (StackdriverListBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
