package me.snowdrop.istio.mixer.adapter.stackdriver;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
import javax.validation.Validator;

public class TraceBuilder extends TraceFluentImpl<TraceBuilder> implements VisitableBuilder<Trace,TraceBuilder>{

    TraceFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public TraceBuilder(){
            this(true);
    }
    public TraceBuilder(Boolean validationEnabled){
            this(new Trace(), validationEnabled);
    }
    public TraceBuilder(TraceFluent<?> fluent){
            this(fluent, true);
    }
    public TraceBuilder(TraceFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new Trace(), validationEnabled);
    }
    public TraceBuilder(TraceFluent<?> fluent,Trace instance){
            this(fluent, instance, true);
    }
    public TraceBuilder(TraceFluent<?> fluent,Trace instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withSampleProbability(instance.getSampleProbability()); 
            this.validationEnabled = validationEnabled; 
    }
    public TraceBuilder(Trace instance){
            this(instance,true);
    }
    public TraceBuilder(Trace instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withSampleProbability(instance.getSampleProbability()); 
            this.validationEnabled = validationEnabled; 
    }
    public TraceBuilder(Validator validator){
            this(new Trace(), true);
    }
    public TraceBuilder(TraceFluent<?> fluent,Trace instance,Validator validator){
            this.fluent = fluent; 
            fluent.withSampleProbability(instance.getSampleProbability()); 
            this.validator = validator;
            this.validationEnabled = validator != null; 
    }
    public TraceBuilder(Trace instance,Validator validator){
            this.fluent = this; 
            this.withSampleProbability(instance.getSampleProbability()); 
            this.validator = validator; 
            this.validationEnabled = validator != null; 
    }

    public Trace build(){
            Trace buildable = new Trace(fluent.getSampleProbability());
            if (validationEnabled) {io.fabric8.kubernetes.api.builder.ValidationUtils.validate(buildable);}
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            TraceBuilder that = (TraceBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
