
package me.snowdrop.istio.mixer.adapter.statsd;

import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.fabric8.kubernetes.api.model.Doneable;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.BuildableReference;
import io.sundr.builder.annotations.Inline;
import lombok.EqualsAndHashCode;
import lombok.ToString;


/**
 * 
 * 
 */
@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder({
    "apiVersion",
    "kind",
    "metadata",
    "nameTemplate",
    "type"
})
@ToString
@EqualsAndHashCode
@Buildable(editableEnabled = false, validationEnabled = true, generateBuilderPackage = true, builderPackage = "io.fabric8.kubernetes.api.builder", inline = {
    @Inline(type = Doneable.class, prefix = "Doneable", value = "done")
}, refs = {
    @BuildableReference(ObjectMeta.class)
})
public class MetricInfo implements Serializable
{

    /**
     * 
     * 
     */
    @JsonProperty("nameTemplate")
    @JsonPropertyDescription("")
    private String nameTemplate;
    @JsonProperty("type")
    private Type type;
    private final static long serialVersionUID = -4008618000368028888L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public MetricInfo() {
    }

    /**
     * 
     * @param nameTemplate
     * @param type
     */
    public MetricInfo(String nameTemplate, Type type) {
        super();
        this.nameTemplate = nameTemplate;
        this.type = type;
    }

    /**
     * 
     * 
     */
    @JsonProperty("nameTemplate")
    public String getNameTemplate() {
        return nameTemplate;
    }

    /**
     * 
     * 
     */
    @JsonProperty("nameTemplate")
    public void setNameTemplate(String nameTemplate) {
        this.nameTemplate = nameTemplate;
    }

    @JsonProperty("type")
    public Type getType() {
        return type;
    }

    @JsonProperty("type")
    public void setType(Type type) {
        this.type = type;
    }

}
