
package me.snowdrop.istio.mixer.adapter.statsd;

import java.io.Serializable;
import java.util.Map;
import javax.validation.Valid;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.fabric8.kubernetes.api.model.Doneable;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.BuildableReference;
import io.sundr.builder.annotations.Inline;
import io.sundr.transform.annotations.VelocityTransformation;
import io.sundr.transform.annotations.VelocityTransformations;
import lombok.EqualsAndHashCode;
import lombok.ToString;
import me.snowdrop.istio.api.IstioSpec;
import me.snowdrop.istio.api.internal.IstioApiVersion;
import me.snowdrop.istio.api.internal.IstioKind;


/**
 * 
 * 
 */
@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder({
    "apiVersion",
    "kind",
    "metadata",
    "address",
    "flushBytes",
    "flushDuration",
    "metrics",
    "prefix",
    "samplingRate"
})
@IstioKind(name = "statsd", plural = "statsds")
@IstioApiVersion("config.istio.io/v1alpha2")
@ToString
@EqualsAndHashCode
@Buildable(editableEnabled = false, validationEnabled = true, generateBuilderPackage = true, builderPackage = "io.fabric8.kubernetes.api.builder", inline = {
    @Inline(type = Doneable.class, prefix = "Doneable", value = "done")
}, refs = {
    @BuildableReference(ObjectMeta.class)
})
@VelocityTransformations({
    @VelocityTransformation("/istio-resource.vm"),
    @VelocityTransformation("/istio-resource-list.vm"),
    @VelocityTransformation(value = "/istio-manifest.vm", outputPath = "crd.properties", gather = true),
    @VelocityTransformation(value = "/istio-mappings-provider.vm", outputPath = "me/snowdrop/istio/api/model/IstioResourceMappingsProvider.java", gather = true)
})
public class StatsdSpec implements Serializable, IstioSpec
{

    /**
     * 
     * 
     */
    @JsonProperty("address")
    @JsonPropertyDescription("")
    private java.lang.String address;
    /**
     * 
     * 
     */
    @JsonProperty("flushBytes")
    @JsonPropertyDescription("")
    private Integer flushBytes;
    /**
     * 
     * 
     */
    @JsonProperty("flushDuration")
    @JsonPropertyDescription("")
    private Long flushDuration;
    /**
     * 
     * 
     */
    @JsonProperty("metrics")
    @JsonPropertyDescription("")
    @Valid
    private Map<String, MetricInfo> metrics;
    /**
     * 
     * 
     */
    @JsonProperty("prefix")
    @JsonPropertyDescription("")
    private java.lang.String prefix;
    /**
     * 
     * 
     */
    @JsonProperty("samplingRate")
    @JsonPropertyDescription("")
    private Double samplingRate;
    private final static long serialVersionUID = -8239715121773884290L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public StatsdSpec() {
    }

    /**
     * 
     * @param address
     * @param prefix
     * @param samplingRate
     * @param metrics
     * @param flushBytes
     * @param flushDuration
     */
    public StatsdSpec(java.lang.String address, Integer flushBytes, Long flushDuration, Map<String, MetricInfo> metrics, java.lang.String prefix, Double samplingRate) {
        super();
        this.address = address;
        this.flushBytes = flushBytes;
        this.flushDuration = flushDuration;
        this.metrics = metrics;
        this.prefix = prefix;
        this.samplingRate = samplingRate;
    }

    /**
     * 
     * 
     */
    @JsonProperty("address")
    public java.lang.String getAddress() {
        return address;
    }

    /**
     * 
     * 
     */
    @JsonProperty("address")
    public void setAddress(java.lang.String address) {
        this.address = address;
    }

    /**
     * 
     * 
     */
    @JsonProperty("flushBytes")
    public Integer getFlushBytes() {
        return flushBytes;
    }

    /**
     * 
     * 
     */
    @JsonProperty("flushBytes")
    public void setFlushBytes(Integer flushBytes) {
        this.flushBytes = flushBytes;
    }

    /**
     * 
     * 
     */
    @JsonProperty("flushDuration")
    public Long getFlushDuration() {
        return flushDuration;
    }

    /**
     * 
     * 
     */
    @JsonProperty("flushDuration")
    public void setFlushDuration(Long flushDuration) {
        this.flushDuration = flushDuration;
    }

    /**
     * 
     * 
     */
    @JsonProperty("metrics")
    public Map<String, MetricInfo> getMetrics() {
        return metrics;
    }

    /**
     * 
     * 
     */
    @JsonProperty("metrics")
    public void setMetrics(Map<String, MetricInfo> metrics) {
        this.metrics = metrics;
    }

    /**
     * 
     * 
     */
    @JsonProperty("prefix")
    public java.lang.String getPrefix() {
        return prefix;
    }

    /**
     * 
     * 
     */
    @JsonProperty("prefix")
    public void setPrefix(java.lang.String prefix) {
        this.prefix = prefix;
    }

    /**
     * 
     * 
     */
    @JsonProperty("samplingRate")
    public Double getSamplingRate() {
        return samplingRate;
    }

    /**
     * 
     * 
     */
    @JsonProperty("samplingRate")
    public void setSamplingRate(Double samplingRate) {
        this.samplingRate = samplingRate;
    }

}
