package me.snowdrop.istio.mixer.adapter.stdio;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
import javax.validation.Validator;

public class StdioListBuilder extends StdioListFluentImpl<StdioListBuilder> implements VisitableBuilder<StdioList,StdioListBuilder>{

    StdioListFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public StdioListBuilder(){
            this(true);
    }
    public StdioListBuilder(Boolean validationEnabled){
            this(new StdioList(), validationEnabled);
    }
    public StdioListBuilder(StdioListFluent<?> fluent){
            this(fluent, true);
    }
    public StdioListBuilder(StdioListFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new StdioList(), validationEnabled);
    }
    public StdioListBuilder(StdioListFluent<?> fluent,StdioList instance){
            this(fluent, instance, true);
    }
    public StdioListBuilder(StdioListFluent<?> fluent,StdioList instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withApiVersion(instance.getApiVersion()); 
            fluent.withItems(instance.getItems()); 
            fluent.withKind(instance.getKind()); 
            fluent.withMetadata(instance.getMetadata()); 
            this.validationEnabled = validationEnabled; 
    }
    public StdioListBuilder(StdioList instance){
            this(instance,true);
    }
    public StdioListBuilder(StdioList instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withApiVersion(instance.getApiVersion()); 
            this.withItems(instance.getItems()); 
            this.withKind(instance.getKind()); 
            this.withMetadata(instance.getMetadata()); 
            this.validationEnabled = validationEnabled; 
    }
    public StdioListBuilder(Validator validator){
            this(new StdioList(), true);
    }
    public StdioListBuilder(StdioListFluent<?> fluent,StdioList instance,Validator validator){
            this.fluent = fluent; 
            fluent.withApiVersion(instance.getApiVersion()); 
            fluent.withItems(instance.getItems()); 
            fluent.withKind(instance.getKind()); 
            fluent.withMetadata(instance.getMetadata()); 
            this.validator = validator;
            this.validationEnabled = validator != null; 
    }
    public StdioListBuilder(StdioList instance,Validator validator){
            this.fluent = this; 
            this.withApiVersion(instance.getApiVersion()); 
            this.withItems(instance.getItems()); 
            this.withKind(instance.getKind()); 
            this.withMetadata(instance.getMetadata()); 
            this.validator = validator; 
            this.validationEnabled = validator != null; 
    }

    public StdioList build(){
            StdioList buildable = new StdioList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
            if (validationEnabled) {io.fabric8.kubernetes.api.builder.ValidationUtils.validate(buildable);}
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            StdioListBuilder that = (StdioListBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
