package me.snowdrop.istio.mixer.template.apikey;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
import javax.validation.Validator;

public class ApiKeyBuilder extends ApiKeyFluentImpl<ApiKeyBuilder> implements VisitableBuilder<ApiKey,ApiKeyBuilder>{

    ApiKeyFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public ApiKeyBuilder(){
            this(true);
    }
    public ApiKeyBuilder(Boolean validationEnabled){
            this(new ApiKey(), validationEnabled);
    }
    public ApiKeyBuilder(ApiKeyFluent<?> fluent){
            this(fluent, true);
    }
    public ApiKeyBuilder(ApiKeyFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new ApiKey(), validationEnabled);
    }
    public ApiKeyBuilder(ApiKeyFluent<?> fluent,ApiKey instance){
            this(fluent, instance, true);
    }
    public ApiKeyBuilder(ApiKeyFluent<?> fluent,ApiKey instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withApiVersion(instance.getApiVersion()); 
            fluent.withKind(instance.getKind()); 
            fluent.withMetadata(instance.getMetadata()); 
            fluent.withSpec(instance.getSpec()); 
            this.validationEnabled = validationEnabled; 
    }
    public ApiKeyBuilder(ApiKey instance){
            this(instance,true);
    }
    public ApiKeyBuilder(ApiKey instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withApiVersion(instance.getApiVersion()); 
            this.withKind(instance.getKind()); 
            this.withMetadata(instance.getMetadata()); 
            this.withSpec(instance.getSpec()); 
            this.validationEnabled = validationEnabled; 
    }
    public ApiKeyBuilder(Validator validator){
            this(new ApiKey(), true);
    }
    public ApiKeyBuilder(ApiKeyFluent<?> fluent,ApiKey instance,Validator validator){
            this.fluent = fluent; 
            fluent.withApiVersion(instance.getApiVersion()); 
            fluent.withKind(instance.getKind()); 
            fluent.withMetadata(instance.getMetadata()); 
            fluent.withSpec(instance.getSpec()); 
            this.validator = validator;
            this.validationEnabled = validator != null; 
    }
    public ApiKeyBuilder(ApiKey instance,Validator validator){
            this.fluent = this; 
            this.withApiVersion(instance.getApiVersion()); 
            this.withKind(instance.getKind()); 
            this.withMetadata(instance.getMetadata()); 
            this.withSpec(instance.getSpec()); 
            this.validator = validator; 
            this.validationEnabled = validator != null; 
    }

    public ApiKey build(){
            ApiKey buildable = new ApiKey(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getSpec());
            if (validationEnabled) {io.fabric8.kubernetes.api.builder.ValidationUtils.validate(buildable);}
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            ApiKeyBuilder that = (ApiKeyBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
