
package me.snowdrop.istio.mixer.template.apikey;

import java.io.Serializable;
import javax.validation.Valid;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.fabric8.kubernetes.api.model.Doneable;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.BuildableReference;
import io.sundr.builder.annotations.Inline;
import io.sundr.transform.annotations.VelocityTransformation;
import io.sundr.transform.annotations.VelocityTransformations;
import lombok.EqualsAndHashCode;
import lombok.ToString;
import me.snowdrop.istio.api.IstioSpec;
import me.snowdrop.istio.api.TimeStamp;
import me.snowdrop.istio.api.internal.IstioApiVersion;
import me.snowdrop.istio.api.internal.IstioKind;


/**
 * 
 * 
 */
@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder({
    "apiVersion",
    "kind",
    "metadata",
    "api",
    "apiKey",
    "apiOperation",
    "name",
    "timestamp"
})
@IstioKind(name = "apikey", plural = "apikeys")
@IstioApiVersion("config.istio.io/v1alpha2")
@ToString
@EqualsAndHashCode
@Buildable(editableEnabled = false, validationEnabled = true, generateBuilderPackage = true, builderPackage = "io.fabric8.kubernetes.api.builder", inline = {
    @Inline(type = Doneable.class, prefix = "Doneable", value = "done")
}, refs = {
    @BuildableReference(ObjectMeta.class)
})
@VelocityTransformations({
    @VelocityTransformation("/istio-resource.vm"),
    @VelocityTransformation("/istio-resource-list.vm"),
    @VelocityTransformation(value = "/istio-manifest.vm", outputPath = "crd.properties", gather = true),
    @VelocityTransformation(value = "/istio-mappings-provider.vm", outputPath = "me/snowdrop/istio/api/model/IstioResourceMappingsProvider.java", gather = true)
})
public class ApiKeySpec implements Serializable, IstioSpec
{

    /**
     * 
     * 
     */
    @JsonProperty("api")
    @JsonPropertyDescription("")
    private String api;
    /**
     * 
     * 
     */
    @JsonProperty("apiKey")
    @JsonPropertyDescription("")
    private String apiKey;
    /**
     * 
     * 
     */
    @JsonProperty("apiOperation")
    @JsonPropertyDescription("")
    private String apiOperation;
    /**
     * 
     * 
     */
    @JsonProperty("apiVersion")
    @JsonPropertyDescription("")
    private String apiVersion;
    /**
     * 
     * 
     */
    @JsonProperty("name")
    @JsonPropertyDescription("")
    private String name;
    /**
     * 
     * 
     */
    @JsonProperty("timestamp")
    @JsonPropertyDescription("")
    @Valid
    private TimeStamp timestamp;
    private final static long serialVersionUID = 6696601075775135720L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public ApiKeySpec() {
    }

    /**
     * 
     * @param apiVersion
     * @param apiKey
     * @param apiOperation
     * @param name
     * @param api
     * @param timestamp
     */
    public ApiKeySpec(String api, String apiKey, String apiOperation, String apiVersion, String name, TimeStamp timestamp) {
        super();
        this.api = api;
        this.apiKey = apiKey;
        this.apiOperation = apiOperation;
        this.apiVersion = apiVersion;
        this.name = name;
        this.timestamp = timestamp;
    }

    /**
     * 
     * 
     */
    @JsonProperty("api")
    public String getApi() {
        return api;
    }

    /**
     * 
     * 
     */
    @JsonProperty("api")
    public void setApi(String api) {
        this.api = api;
    }

    /**
     * 
     * 
     */
    @JsonProperty("apiKey")
    public String getApiKey() {
        return apiKey;
    }

    /**
     * 
     * 
     */
    @JsonProperty("apiKey")
    public void setApiKey(String apiKey) {
        this.apiKey = apiKey;
    }

    /**
     * 
     * 
     */
    @JsonProperty("apiOperation")
    public String getApiOperation() {
        return apiOperation;
    }

    /**
     * 
     * 
     */
    @JsonProperty("apiOperation")
    public void setApiOperation(String apiOperation) {
        this.apiOperation = apiOperation;
    }

    /**
     * 
     * 
     */
    @JsonProperty("apiVersion")
    public String getApiVersion() {
        return apiVersion;
    }

    /**
     * 
     * 
     */
    @JsonProperty("apiVersion")
    public void setApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
    }

    /**
     * 
     * 
     */
    @JsonProperty("name")
    public String getName() {
        return name;
    }

    /**
     * 
     * 
     */
    @JsonProperty("name")
    public void setName(String name) {
        this.name = name;
    }

    /**
     * 
     * 
     */
    @JsonProperty("timestamp")
    public TimeStamp getTimestamp() {
        return timestamp;
    }

    /**
     * 
     * 
     */
    @JsonProperty("timestamp")
    public void setTimestamp(TimeStamp timestamp) {
        this.timestamp = timestamp;
    }

}
