package me.snowdrop.istio.mixer.template.authorization;

import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import javax.validation.constraints.NotNull;
import io.fabric8.kubernetes.api.builder.Predicate;
import io.fabric8.kubernetes.api.model.ListMeta;
import java.lang.Deprecated;
import javax.validation.Valid;
import java.util.Collection;
import java.util.List;
import java.lang.Boolean;

public interface AuthorizationListFluent<A extends AuthorizationListFluent<A>> extends Fluent<A>{


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public Boolean hasApiVersion();
    public A addToItems(int index,Authorization item);
    public A setToItems(int index,Authorization item);
    public A addToItems(Authorization... items);
    public A addAllToItems(Collection<Authorization> items);
    public A removeFromItems(Authorization... items);
    public A removeAllFromItems(Collection<Authorization> items);
    
/**
 * This method has been deprecated, please use method buildItems instead.
 * @return The buildable object.
 */
@Deprecated public List<Authorization> getItems();
    public List<Authorization> buildItems();
    public Authorization buildItem(int index);
    public Authorization buildFirstItem();
    public Authorization buildLastItem();
    public Authorization buildMatchingItem(Predicate<AuthorizationBuilder> predicate);
    public A withItems(List<Authorization> items);
    public A withItems(Authorization... items);
    public Boolean hasItems();
    public AuthorizationListFluent.ItemsNested<A> addNewItem();
    public AuthorizationListFluent.ItemsNested<A> addNewItemLike(Authorization item);
    public AuthorizationListFluent.ItemsNested<A> setNewItemLike(int index,Authorization item);
    public AuthorizationListFluent.ItemsNested<A> editItem(int index);
    public AuthorizationListFluent.ItemsNested<A> editFirstItem();
    public AuthorizationListFluent.ItemsNested<A> editLastItem();
    public AuthorizationListFluent.ItemsNested<A> editMatchingItem(Predicate<AuthorizationBuilder> predicate);
    public String getKind();
    public A withKind(String kind);
    public Boolean hasKind();
    public ListMeta getMetadata();
    public A withMetadata(ListMeta metadata);
    public Boolean hasMetadata();
    public A withNewMetadata(String _continue,String resourceVersion,String selfLink);

    public interface ItemsNested<N> extends Nested<N>,AuthorizationFluent<AuthorizationListFluent.ItemsNested<N>>{

        
    public N and();    public N endItem();
}


}
