package me.snowdrop.istio.mixer.template.metric;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
import javax.validation.Validator;

public class MetricBuilder extends MetricFluentImpl<MetricBuilder> implements VisitableBuilder<Metric,MetricBuilder>{

    MetricFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public MetricBuilder(){
            this(true);
    }
    public MetricBuilder(Boolean validationEnabled){
            this(new Metric(), validationEnabled);
    }
    public MetricBuilder(MetricFluent<?> fluent){
            this(fluent, true);
    }
    public MetricBuilder(MetricFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new Metric(), validationEnabled);
    }
    public MetricBuilder(MetricFluent<?> fluent,Metric instance){
            this(fluent, instance, true);
    }
    public MetricBuilder(MetricFluent<?> fluent,Metric instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withApiVersion(instance.getApiVersion()); 
            fluent.withKind(instance.getKind()); 
            fluent.withMetadata(instance.getMetadata()); 
            fluent.withSpec(instance.getSpec()); 
            this.validationEnabled = validationEnabled; 
    }
    public MetricBuilder(Metric instance){
            this(instance,true);
    }
    public MetricBuilder(Metric instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withApiVersion(instance.getApiVersion()); 
            this.withKind(instance.getKind()); 
            this.withMetadata(instance.getMetadata()); 
            this.withSpec(instance.getSpec()); 
            this.validationEnabled = validationEnabled; 
    }
    public MetricBuilder(Validator validator){
            this(new Metric(), true);
    }
    public MetricBuilder(MetricFluent<?> fluent,Metric instance,Validator validator){
            this.fluent = fluent; 
            fluent.withApiVersion(instance.getApiVersion()); 
            fluent.withKind(instance.getKind()); 
            fluent.withMetadata(instance.getMetadata()); 
            fluent.withSpec(instance.getSpec()); 
            this.validator = validator;
            this.validationEnabled = validator != null; 
    }
    public MetricBuilder(Metric instance,Validator validator){
            this.fluent = this; 
            this.withApiVersion(instance.getApiVersion()); 
            this.withKind(instance.getKind()); 
            this.withMetadata(instance.getMetadata()); 
            this.withSpec(instance.getSpec()); 
            this.validator = validator; 
            this.validationEnabled = validator != null; 
    }

    public Metric build(){
            Metric buildable = new Metric(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getSpec());
            if (validationEnabled) {io.fabric8.kubernetes.api.builder.ValidationUtils.validate(buildable);}
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            MetricBuilder that = (MetricBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
