package me.snowdrop.istio.mixer.template.metric;

import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.Nested;
import com.fasterxml.jackson.databind.JsonSerializer;
import java.lang.String;
import com.fasterxml.jackson.databind.JsonDeserializer;
import java.util.LinkedHashMap;
import me.snowdrop.istio.api.cexl.TypedValueFluentImpl;
import me.snowdrop.istio.api.cexl.TypedValueBuilder;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.SerializerProvider;
import java.lang.Boolean;
import java.lang.Override;
import com.fasterxml.jackson.core.JsonParser;
import me.snowdrop.istio.api.cexl.TypedValue;
import javax.validation.Valid;
import java.lang.Object;
import java.util.Map;

public class MetricSpecFluentImpl<A extends MetricSpecFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements MetricSpecFluent<A>{

    private Map<String,TypedValue> dimensions;
    private Map<String,TypedValue> monitoredResourceDimensions;
    private String monitoredResourceType;
    private String name;
    private TypedValueBuilder value;

    public MetricSpecFluentImpl(){
    }
    public MetricSpecFluentImpl(MetricSpec instance){
            this.withDimensions(instance.getDimensions()); 
            this.withMonitoredResourceDimensions(instance.getMonitoredResourceDimensions()); 
            this.withMonitoredResourceType(instance.getMonitoredResourceType()); 
            this.withName(instance.getName()); 
            this.withValue(instance.getValue()); 
    }

    public A addToDimensions(String key,TypedValue value){
            if(this.dimensions == null && key != null && value != null) { this.dimensions = new LinkedHashMap<String,TypedValue>(); }
            if(key != null && value != null) {this.dimensions.put(key, value);} return (A)this;
    }

    public A addToDimensions(Map<String,TypedValue> map){
            if(this.dimensions == null && map != null) { this.dimensions = new LinkedHashMap<String,TypedValue>(); }
            if(map != null) { this.dimensions.putAll(map);} return (A)this;
    }

    public A removeFromDimensions(String key){
            if(this.dimensions == null) { return (A) this; }
            if(key != null && this.dimensions != null) {this.dimensions.remove(key);} return (A)this;
    }

    public A removeFromDimensions(Map<String,TypedValue> map){
            if(this.dimensions == null) { return (A) this; }
            if(map != null) { for(Object key : map.keySet()) {if (this.dimensions != null){this.dimensions.remove(key);}}} return (A)this;
    }

    public Map<String,TypedValue> getDimensions(){
            return this.dimensions;
    }

    public A withDimensions(Map<String,TypedValue> dimensions){
            if (dimensions == null) { this.dimensions =  null;} else {this.dimensions = new LinkedHashMap<String,TypedValue>(dimensions);} return (A) this;
    }

    public Boolean hasDimensions(){
            return this.dimensions != null;
    }

    public A addToMonitoredResourceDimensions(String key,TypedValue value){
            if(this.monitoredResourceDimensions == null && key != null && value != null) { this.monitoredResourceDimensions = new LinkedHashMap<String,TypedValue>(); }
            if(key != null && value != null) {this.monitoredResourceDimensions.put(key, value);} return (A)this;
    }

    public A addToMonitoredResourceDimensions(Map<String,TypedValue> map){
            if(this.monitoredResourceDimensions == null && map != null) { this.monitoredResourceDimensions = new LinkedHashMap<String,TypedValue>(); }
            if(map != null) { this.monitoredResourceDimensions.putAll(map);} return (A)this;
    }

    public A removeFromMonitoredResourceDimensions(String key){
            if(this.monitoredResourceDimensions == null) { return (A) this; }
            if(key != null && this.monitoredResourceDimensions != null) {this.monitoredResourceDimensions.remove(key);} return (A)this;
    }

    public A removeFromMonitoredResourceDimensions(Map<String,TypedValue> map){
            if(this.monitoredResourceDimensions == null) { return (A) this; }
            if(map != null) { for(Object key : map.keySet()) {if (this.monitoredResourceDimensions != null){this.monitoredResourceDimensions.remove(key);}}} return (A)this;
    }

    public Map<String,TypedValue> getMonitoredResourceDimensions(){
            return this.monitoredResourceDimensions;
    }

    public A withMonitoredResourceDimensions(Map<String,TypedValue> monitoredResourceDimensions){
            if (monitoredResourceDimensions == null) { this.monitoredResourceDimensions =  null;} else {this.monitoredResourceDimensions = new LinkedHashMap<String,TypedValue>(monitoredResourceDimensions);} return (A) this;
    }

    public Boolean hasMonitoredResourceDimensions(){
            return this.monitoredResourceDimensions != null;
    }

    public String getMonitoredResourceType(){
            return this.monitoredResourceType;
    }

    public A withMonitoredResourceType(String monitoredResourceType){
            this.monitoredResourceType=monitoredResourceType; return (A) this;
    }

    public Boolean hasMonitoredResourceType(){
            return this.monitoredResourceType != null;
    }

    public String getName(){
            return this.name;
    }

    public A withName(String name){
            this.name=name; return (A) this;
    }

    public Boolean hasName(){
            return this.name != null;
    }

    
/**
 * This method has been deprecated, please use method buildValue instead.
 * @return The buildable object.
 */
@Deprecated public TypedValue getValue(){
            return this.value!=null?this.value.build():null;
    }

    public TypedValue buildValue(){
            return this.value!=null?this.value.build():null;
    }

    public A withValue(TypedValue value){
            _visitables.remove(this.value);
            if (value!=null){ this.value= new TypedValueBuilder(value); _visitables.add(this.value);} return (A) this;
    }

    public Boolean hasValue(){
            return this.value != null;
    }

    public MetricSpecFluent.ValueNested<A> withNewValue(){
            return new ValueNestedImpl();
    }

    public MetricSpecFluent.ValueNested<A> withNewValueLike(TypedValue item){
            return new ValueNestedImpl(item);
    }

    public MetricSpecFluent.ValueNested<A> editValue(){
            return withNewValueLike(getValue());
    }

    public MetricSpecFluent.ValueNested<A> editOrNewValue(){
            return withNewValueLike(getValue() != null ? getValue(): new TypedValueBuilder().build());
    }

    public MetricSpecFluent.ValueNested<A> editOrNewValueLike(TypedValue item){
            return withNewValueLike(getValue() != null ? getValue(): item);
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            MetricSpecFluentImpl that = (MetricSpecFluentImpl) o;
            if (dimensions != null ? !dimensions.equals(that.dimensions) :that.dimensions != null) return false;
            if (monitoredResourceDimensions != null ? !monitoredResourceDimensions.equals(that.monitoredResourceDimensions) :that.monitoredResourceDimensions != null) return false;
            if (monitoredResourceType != null ? !monitoredResourceType.equals(that.monitoredResourceType) :that.monitoredResourceType != null) return false;
            if (name != null ? !name.equals(that.name) :that.name != null) return false;
            if (value != null ? !value.equals(that.value) :that.value != null) return false;
            return true;
    }


    public class ValueNestedImpl<N> extends TypedValueFluentImpl<MetricSpecFluent.ValueNested<N>> implements MetricSpecFluent.ValueNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final TypedValueBuilder builder;
    
            ValueNestedImpl(TypedValue item){
                    this.builder = new TypedValueBuilder(this, item);
            }
            ValueNestedImpl(){
                    this.builder = new TypedValueBuilder(this);
            }
    
    public N and(){
            return (N) MetricSpecFluentImpl.this.withValue(builder.build());
    }
    public N endValue(){
            return and();
    }

}


}
