package me.snowdrop.istio.mixer.template.quota;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
import javax.validation.Validator;

public class QuotaSpecBuilder extends QuotaSpecFluentImpl<QuotaSpecBuilder> implements VisitableBuilder<QuotaSpec,QuotaSpecBuilder>{

    QuotaSpecFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public QuotaSpecBuilder(){
            this(true);
    }
    public QuotaSpecBuilder(Boolean validationEnabled){
            this(new QuotaSpec(), validationEnabled);
    }
    public QuotaSpecBuilder(QuotaSpecFluent<?> fluent){
            this(fluent, true);
    }
    public QuotaSpecBuilder(QuotaSpecFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new QuotaSpec(), validationEnabled);
    }
    public QuotaSpecBuilder(QuotaSpecFluent<?> fluent,QuotaSpec instance){
            this(fluent, instance, true);
    }
    public QuotaSpecBuilder(QuotaSpecFluent<?> fluent,QuotaSpec instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withDimensions(instance.getDimensions()); 
            fluent.withName(instance.getName()); 
            this.validationEnabled = validationEnabled; 
    }
    public QuotaSpecBuilder(QuotaSpec instance){
            this(instance,true);
    }
    public QuotaSpecBuilder(QuotaSpec instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withDimensions(instance.getDimensions()); 
            this.withName(instance.getName()); 
            this.validationEnabled = validationEnabled; 
    }
    public QuotaSpecBuilder(Validator validator){
            this(new QuotaSpec(), true);
    }
    public QuotaSpecBuilder(QuotaSpecFluent<?> fluent,QuotaSpec instance,Validator validator){
            this.fluent = fluent; 
            fluent.withDimensions(instance.getDimensions()); 
            fluent.withName(instance.getName()); 
            this.validator = validator;
            this.validationEnabled = validator != null; 
    }
    public QuotaSpecBuilder(QuotaSpec instance,Validator validator){
            this.fluent = this; 
            this.withDimensions(instance.getDimensions()); 
            this.withName(instance.getName()); 
            this.validator = validator; 
            this.validationEnabled = validator != null; 
    }

    public QuotaSpec build(){
            QuotaSpec buildable = new QuotaSpec(fluent.getDimensions(),fluent.getName());
            if (validationEnabled) {io.fabric8.kubernetes.api.builder.ValidationUtils.validate(buildable);}
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            QuotaSpecBuilder that = (QuotaSpecBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
