/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.util;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigException;
import com.typesafe.config.ConfigFactory;
import java.io.File;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigCache {
    private static final ConfigCache INSTANCE = new ConfigCache();
    private static final Logger LOGGER = LoggerFactory.getLogger(ConfigCache.class);
    private Map<File, Config> loadedConfigFiles = new ConcurrentHashMap<File, Config>();

    public static ConfigCache instance() {
        return INSTANCE;
    }

    public Config getConfig(File configFile) {
        this.loadedConfigFiles.computeIfAbsent(configFile, this::load);
        return this.loadedConfigFiles.get(configFile);
    }

    private Config load(File configFile) {
        try {
            return ConfigFactory.parseFile((File)configFile).resolveWith(ConfigFactory.systemProperties());
        }
        catch (ConfigException failedToReadTheSerenityConfFile) {
            try {
                LOGGER.warn("Failed to read the serenity.conf file: " + failedToReadTheSerenityConfFile.getMessage() + " - Falling back on serenity.conf without using environment variables");
                return ConfigFactory.parseFile((File)configFile);
            }
            catch (ConfigException failedToReadTheUnresolvedSerenityConfFile) {
                LOGGER.error("Failed to parse the serenity.conf file", (Throwable)failedToReadTheUnresolvedSerenityConfFile);
                throw failedToReadTheUnresolvedSerenityConfFile;
            }
        }
    }

    public void clear() {
        this.loadedConfigFiles.clear();
    }
}

