/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.util;

import net.thucydides.core.reports.html.TagFilter;
import net.thucydides.core.util.EnvironmentVariables;
import net.thucydides.core.util.Inflector;
import org.apache.commons.lang3.StringUtils;

public class TagInflector {
    private static TagFilter tagFilter;

    public TagInflector(EnvironmentVariables environmentVariables) {
        tagFilter = new TagFilter(environmentVariables);
    }

    public InflectableTag ofTag(String tagType, String tagName) {
        return new InflectableTag(tagType, tagName);
    }

    public static final class InflectableTag {
        private String tagType;
        private String tagName;

        InflectableTag(String tagType, String tagName) {
            this.tagType = tagType;
            this.tagName = tagName;
        }

        public String toFinalView() {
            if (this.shouldFormatAsTitle()) {
                return this.asTitle();
            }
            return this.rawName();
        }

        private boolean shouldFormatAsTitle() {
            return !tagFilter.rawTagTypes().contains(StringUtils.lowerCase((String)this.tagType));
        }

        private String asTitle() {
            return Inflector.getInstance().of(this.tagName).asATitle().toString();
        }

        private String rawName() {
            return this.tagName;
        }
    }
}

