/*
 * Decompiled with CFR 0.152.
 */
package nl.hsac.fitnesse.fixture;

import fit.exception.FitFailureException;
import freemarker.template.Configuration;
import freemarker.template.DefaultObjectWrapperBuilder;
import freemarker.template.ObjectWrapper;
import freemarker.template.Template;
import java.io.File;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import nl.hsac.fitnesse.fixture.util.DatesHelper;
import nl.hsac.fitnesse.fixture.util.Formatter;
import nl.hsac.fitnesse.fixture.util.FreeMarkerHelper;
import nl.hsac.fitnesse.fixture.util.HtmlCleaner;
import nl.hsac.fitnesse.fixture.util.HttpClient;
import nl.hsac.fitnesse.fixture.util.HttpResponse;
import nl.hsac.fitnesse.fixture.util.JsonHelper;
import nl.hsac.fitnesse.fixture.util.JsonPathHelper;
import nl.hsac.fitnesse.fixture.util.LineEndingHelper;
import nl.hsac.fitnesse.fixture.util.MapHelper;
import nl.hsac.fitnesse.fixture.util.NamespaceContextImpl;
import nl.hsac.fitnesse.fixture.util.ProgramHelper;
import nl.hsac.fitnesse.fixture.util.ProgramResponse;
import nl.hsac.fitnesse.fixture.util.PropertiesHelper;
import nl.hsac.fitnesse.fixture.util.ReflectionHelper;
import nl.hsac.fitnesse.fixture.util.SecretMasker;
import nl.hsac.fitnesse.fixture.util.TextFormatter;
import nl.hsac.fitnesse.fixture.util.TimeoutHelper;
import nl.hsac.fitnesse.fixture.util.XMLFormatter;
import nl.hsac.fitnesse.fixture.util.XPathHelper;
import nl.hsac.fitnesse.fixture.util.XmlHttpResponse;
import nl.hsac.fitnesse.fixture.util.ZipHelper;
import nl.hsac.fitnesse.fixture.util.selenium.CookieConverter;
import nl.hsac.fitnesse.fixture.util.selenium.SeleniumHelper;
import nl.hsac.fitnesse.fixture.util.selenium.driverfactory.DriverManager;
import org.apache.commons.text.StringEscapeUtils;
import org.apache.http.client.CookieStore;
import org.apache.http.impl.client.BasicCookieStore;
import org.openqa.selenium.Cookie;

public class Environment {
    private static final Environment INSTANCE = new Environment();
    private String fitNesseDir = ".";
    private String fitNesseRoot = "FitNesseRoot";
    private Configuration freemarkerConfig;
    private FreeMarkerHelper fmHelper;
    private ConcurrentHashMap<String, Template> templateCache;
    private ConcurrentHashMap<String, String> symbols;
    private HttpClient httpClient;
    private long nextSequenceNr = System.currentTimeMillis();
    private NamespaceContextImpl nsContext;
    private XPathHelper xPathHelper;
    private TextFormatter textFormatter;
    private XMLFormatter xmlFormatter;
    private JsonPathHelper jsonPathHelper;
    private JsonHelper jsonHelper;
    private HtmlCleaner htmlCleaner;
    private TimeoutHelper timeoutHelper = new TimeoutHelper();
    private ProgramHelper programHelper;
    private DatesHelper datesHelper = new DatesHelper();
    private DriverManager driverManager;
    private CookieConverter cookieConverter;
    private MapHelper mapHelper = new MapHelper();
    private ReflectionHelper reflectionHelper = new ReflectionHelper();
    private SecretMasker secretMasker = new SecretMasker();
    private LineEndingHelper lineEndingHelper = new LineEndingHelper();
    private PropertiesHelper propertiesHelper = new PropertiesHelper();
    private ZipHelper zipHelper = new ZipHelper();

    private Environment() {
        Configuration cfg = new Configuration(Configuration.VERSION_2_3_23);
        cfg.setClassForTemplateLoading(this.getClass(), "/templates/");
        DefaultObjectWrapperBuilder builder = new DefaultObjectWrapperBuilder(Configuration.VERSION_2_3_23);
        builder.setExposeFields(true);
        cfg.setObjectWrapper((ObjectWrapper)builder.build());
        this.freemarkerConfig = cfg;
        this.fmHelper = new FreeMarkerHelper();
        this.templateCache = new ConcurrentHashMap();
        this.symbols = new ConcurrentHashMap();
        this.textFormatter = new TextFormatter();
        this.xmlFormatter = new XMLFormatter();
        this.nsContext = new NamespaceContextImpl();
        this.fillNamespaceContext();
        this.xPathHelper = new XPathHelper();
        this.jsonPathHelper = new JsonPathHelper();
        this.jsonHelper = new JsonHelper();
        this.htmlCleaner = new HtmlCleaner();
        this.httpClient = new HttpClient();
        this.programHelper = new ProgramHelper();
        this.programHelper.setTimeoutHelper(this.timeoutHelper);
        this.configDatesHelper();
        this.driverManager = new DriverManager();
        this.cookieConverter = new CookieConverter();
    }

    private void fillNamespaceContext() {
        this.registerNamespace("env", "http://schemas.xmlsoap.org/soap/envelope/");
        this.registerNamespace("xsi", "http://www.w3.org/2001/XMLSchema-instance");
    }

    public static Environment getInstance() {
        return INSTANCE;
    }

    public <T> T createInstance(Class<T> clazz) {
        try {
            return clazz.newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to create instance of: " + clazz.getName(), e);
        }
    }

    public void setSymbol(String key, String value) {
        if (value == null) {
            this.symbols.remove(key);
        } else {
            this.symbols.put(key, value);
        }
    }

    public String getSymbol(String key) {
        return this.symbols.get(key);
    }

    public long getNextNr() {
        return this.nextSequenceNr++;
    }

    public void setNextNr(long value) {
        this.nextSequenceNr = value;
    }

    public String getRequiredSymbol(String key) {
        String result = null;
        String symbol = this.getSymbol(key);
        if (symbol == null) {
            throw new FitFailureException("No Symbol defined with key: " + key);
        }
        result = symbol.toString();
        return result;
    }

    public Configuration getConfiguration() {
        return this.freemarkerConfig;
    }

    public Template getTemplate(String name) {
        Template result;
        if (!this.templateCache.containsKey(name)) {
            Template t = this.fmHelper.getTemplate(this.getConfiguration(), name);
            result = this.templateCache.putIfAbsent(name, t);
            if (result == null) {
                result = t;
            }
        } else {
            result = this.templateCache.get(name);
        }
        return result;
    }

    public String processTemplate(String templateName, Object model) {
        Template t = this.getTemplate(templateName);
        return this.fmHelper.processTemplate(t, model);
    }

    public void callService(String url, String templateName, Object model, XmlHttpResponse result) {
        this.callService(url, templateName, model, result, null);
    }

    public void callService(String url, String templateName, Object model, XmlHttpResponse result, Map<String, Object> headers) {
        this.doHttpPost(url, templateName, model, result, headers, "text/xml; charset=UTF-8");
        this.setContext(result);
    }

    public void doHttpPost(String url, String templateName, Object model, HttpResponse result) {
        this.doHttpPost(url, templateName, model, result, null, "text/xml; charset=UTF-8");
    }

    public void doHttpPost(String url, String templateName, Object model, HttpResponse result, Map<String, Object> headers, String contentType) {
        String request = this.processTemplate(templateName, model);
        result.setRequest(request);
        this.doHttpPost(url, result, headers, contentType);
    }

    public void doHttpPost(String url, HttpResponse result, Map<String, Object> headers, String contentType) {
        this.httpClient.post(url, result, headers, contentType);
    }

    public void doHttpFilePost(String url, HttpResponse result, Map<String, Object> headers, File file) {
        this.httpClient.post(url, result, headers, file);
    }

    public void doHttpFilePut(String url, HttpResponse result, Map<String, Object> headers, File file) {
        this.httpClient.put(url, result, headers, file);
    }

    public void doHttpPut(String url, String templateName, Object model, HttpResponse result) {
        this.doHttpPut(url, templateName, model, result, null, "text/xml; charset=UTF-8");
    }

    public void doHttpPut(String url, String templateName, Object model, HttpResponse result, Map<String, Object> headers, String contentType) {
        String request = this.processTemplate(templateName, model);
        result.setRequest(request);
        this.doHttpPut(url, result, headers, contentType);
    }

    public void doHttpPut(String url, HttpResponse result, Map<String, Object> headers, String contentType) {
        this.httpClient.put(url, result, headers, contentType);
    }

    public HttpResponse doHttpGet(String url, Map<String, Object> headers, boolean followRedirect) {
        HttpResponse response = new HttpResponse();
        this.doGet(url, response, headers, followRedirect);
        return response;
    }

    public XmlHttpResponse doHttpGetXml(String url) {
        XmlHttpResponse response = new XmlHttpResponse();
        this.doGet(url, response);
        this.setContext(response);
        return response;
    }

    public void doGet(String url, HttpResponse response, Map<String, Object> headers, boolean followRedirect) {
        response.setRequest(url);
        this.httpClient.get(url, response, headers, followRedirect);
    }

    public void doGet(String url, HttpResponse response, Map<String, Object> headers) {
        this.doGet(url, response, headers, true);
    }

    public void doGet(String url, HttpResponse response) {
        this.doGet(url, response, null, true);
    }

    public void doGet(String url, HttpResponse response, boolean followRedirect) {
        this.doGet(url, response, null, followRedirect);
    }

    public void doHead(String url, HttpResponse response, Map<String, Object> headers) {
        response.setRequest(url);
        this.httpClient.head(url, response, headers);
    }

    public void doDelete(String url, HttpResponse response, Map<String, Object> headers) {
        response.setRequest(url);
        this.httpClient.delete(url, response, headers);
    }

    public void doDelete(String url, String templateName, Object model, HttpResponse result, Map<String, Object> headers, String contentType) {
        String request = this.processTemplate(templateName, model);
        result.setRequest(request);
        this.doDelete(url, result, headers, contentType);
    }

    public void doDelete(String url, HttpResponse result, Map<String, Object> headers, String contentType) {
        this.httpClient.delete(url, result, headers, contentType);
    }

    public void doHttpPatch(String url, String templateName, Object model, HttpResponse result, Map<String, Object> headers, String contentType) {
        String request = this.processTemplate(templateName, model);
        result.setRequest(request);
        this.doHttpPatch(url, result, headers, contentType);
    }

    public void doHttpPatch(String url, HttpResponse result, Map<String, Object> headers, String contentType) {
        this.httpClient.patch(url, result, headers, contentType);
    }

    public HttpClient getHttpClient() {
        return this.httpClient;
    }

    public void setContext(XmlHttpResponse response) {
        response.setNamespaceContext(this.getNamespaceContext());
        response.setXPathHelper(this.getXPathHelper());
    }

    public void registerNamespace(String prefix, String uri) {
        this.nsContext.add(prefix, uri);
    }

    public NamespaceContextImpl getNamespaceContext() {
        return this.nsContext;
    }

    public XPathHelper getXPathHelper() {
        return this.xPathHelper;
    }

    public String getHtml(String content) {
        return this.getHtml(this.textFormatter, content);
    }

    public String getHtmlForXml(String xmlString) {
        return this.getHtml(this.xmlFormatter, xmlString);
    }

    public String getHtmlForJson(String jsonString) {
        return this.getHtml(this.jsonHelper, jsonString);
    }

    public String getHtml(Formatter formatter, String value) {
        String result = null;
        if (value != null) {
            if ("".equals(value)) {
                result = "";
            } else {
                String formattedResponse = formatter.format(value);
                result = "<pre>" + StringEscapeUtils.escapeHtml4((String)formattedResponse) + "</pre>";
            }
        }
        return result;
    }

    public static void handleErrorResponse(String msg, String responseText) {
        String responseHtml;
        Environment instance = Environment.getInstance();
        try {
            responseHtml = instance.getHtmlForXml(responseText);
        }
        catch (Exception e) {
            responseHtml = instance.getHtml(value -> value, responseText);
        }
        throw new FitFailureException(msg + responseHtml);
    }

    public HtmlCleaner getHtmlCleaner() {
        return this.htmlCleaner;
    }

    public ProgramResponse invokeProgram(int timeout, String directory, String command, String ... arguments) {
        ProgramResponse result = new ProgramResponse();
        result.setDirectory(directory);
        result.setCommand(command);
        result.setArguments(arguments);
        this.invokeProgram(timeout, result);
        return result;
    }

    public void invokeProgram(int timeout, ProgramResponse result) {
        this.programHelper.execute(result, timeout);
    }

    private void configDatesHelper() {
        this.datesHelper.setDayPattern("%s_dag");
        this.datesHelper.setMonthPattern("%s_maand");
        this.datesHelper.setYearPattern("%s_jaar");
    }

    public DatesHelper getDatesHelper() {
        return this.datesHelper;
    }

    public SeleniumHelper getSeleniumHelper() {
        return this.driverManager.getSeleniumHelper();
    }

    public DriverManager getSeleniumDriverManager() {
        return this.driverManager;
    }

    public void setSeleniumDriverManager(DriverManager driverManager) {
        this.driverManager = driverManager;
    }

    public String getFitNesseDir() {
        return this.fitNesseDir;
    }

    public void setFitNesseDir(String fitNesseDir) {
        this.fitNesseDir = fitNesseDir;
    }

    public String getFitNesseRootDir() {
        return this.fitNesseRoot;
    }

    public String getFitNesseFilesSectionDir() {
        return new File(this.fitNesseRoot, "files").getAbsolutePath();
    }

    public void setFitNesseRoot(String fitNesseRoot) {
        File root = new File(fitNesseRoot);
        if (!root.exists() || !root.isDirectory()) {
            throw new IllegalArgumentException("value for fitNesseRoot must be an existing directory");
        }
        this.fitNesseRoot = fitNesseRoot;
    }

    public String getWikiUrl(String filePath) {
        String wikiUrl = null;
        String filesDir = this.getFitNesseFilesSectionDir();
        if (filePath.startsWith(filesDir)) {
            String relativeFile = filePath.substring(filesDir.length());
            relativeFile = relativeFile.replace('\\', '/');
            wikiUrl = "files" + relativeFile;
        }
        return wikiUrl;
    }

    public String getFilePathFromWikiUrl(String wikiUrl) {
        File file;
        String url = this.getHtmlCleaner().getUrl(wikiUrl);
        if (url.startsWith("files/")) {
            String relativeFile = url.substring("files".length());
            relativeFile = relativeFile.replace('/', File.separatorChar);
            String pathname = this.getFitNesseFilesSectionDir() + relativeFile;
            file = new File(pathname);
        } else {
            file = new File(url);
        }
        return file.exists() ? file.getAbsolutePath() : url;
    }

    public MapHelper getMapHelper() {
        return this.mapHelper;
    }

    public void setMapHelper(MapHelper aMapHelper) {
        this.mapHelper = aMapHelper;
    }

    public XMLFormatter getXmlFormatter() {
        return this.xmlFormatter;
    }

    public JsonPathHelper getJsonPathHelper() {
        return this.jsonPathHelper;
    }

    public JsonHelper getJsonHelper() {
        return this.jsonHelper;
    }

    public ReflectionHelper getReflectionHelper() {
        return this.reflectionHelper;
    }

    public void addSeleniumCookies(HttpResponse response) {
        CookieStore cookieStore = this.ensureResponseHasCookieStore(response);
        CookieConverter converter = this.getCookieConverter();
        Set<Cookie> browserCookies = this.getSeleniumHelper().getCookies();
        converter.copySeleniumCookies(browserCookies, cookieStore);
    }

    protected CookieStore ensureResponseHasCookieStore(HttpResponse response) {
        CookieStore cookieStore = response.getCookieStore();
        if (cookieStore == null) {
            cookieStore = new BasicCookieStore();
            response.setCookieStore(cookieStore);
        }
        return cookieStore;
    }

    public CookieConverter getCookieConverter() {
        return this.cookieConverter;
    }

    public void setCookieConverter(CookieConverter cookieConverter) {
        this.cookieConverter = cookieConverter;
    }

    public SecretMasker getSecretMasker() {
        return this.secretMasker;
    }

    public void setSecretMasker(SecretMasker secretMasker) {
        this.secretMasker = secretMasker;
    }

    public LineEndingHelper getLineEndingHelper() {
        return this.lineEndingHelper;
    }

    public void setLineEndingHelper(LineEndingHelper lineEndingHelper) {
        this.lineEndingHelper = lineEndingHelper;
    }

    public PropertiesHelper getPropertiesHelper() {
        return this.propertiesHelper;
    }

    public void setPropertiesHelper(PropertiesHelper propertiesHelper) {
        this.propertiesHelper = propertiesHelper;
    }

    public ZipHelper getZipHelper() {
        return this.zipHelper;
    }

    public void setZipHelper(ZipHelper zipHelper) {
        this.zipHelper = zipHelper;
    }

    public void enableHttpClientCompression() {
        this.httpClient.enableCompression();
    }

    public void disableHttpClientCompression() {
        this.httpClient.disableCompression();
    }

    public void disableHttpClientSSLVerification() {
        this.httpClient.disableSSLVerification();
    }

    public void enableHttpClientSSLVerification() {
        this.httpClient.enableSSLVerification();
    }
}

