/*
 * Decompiled with CFR 0.152.
 */
package nl.hsac.fitnesse.fixture.fit;

import fit.Binding;
import fit.Fixture;
import fit.Parse;
import fit.exception.FitFailureException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import nl.hsac.fitnesse.fixture.fit.MapParameter;
import nl.hsac.fitnesse.fixture.fit.OurColumnFixture;
import nl.hsac.fitnesse.fixture.util.HttpResponse;
import org.apache.commons.lang3.StringUtils;

public class MapColumnFixture
extends OurColumnFixture {
    private final Map<String, Object> currentRowValues = new HashMap<String, Object>();
    public static final String DEFAULT_ARRAY_SEPARATOR = ",";
    private static final String REGEX_STRING_WITH_SYMBOL = "(.*?)(\\$\\[)(.*?)(\\])(.*)";
    private static final Pattern STRING_WITH_SYMBOL_PATTERN = Pattern.compile("(.*?)(\\$\\[)(.*?)(\\])(.*)");

    public void reset() {
        this.currentRowValues.clear();
        this.setDefaults(this.getCurrentRowValues());
    }

    public void translateFromTable(String[][] translationTableWithHeader) {
        MapColumnFixture.translateFromTable(this.getCurrentRowValues(), translationTableWithHeader);
    }

    public static void translateFromTable(Map<String, Object> rowValues, String[][] translationTableWithHeader) {
        MapColumnFixture.translateFromTable(rowValues, translationTableWithHeader, 0, 1);
        MapColumnFixture.translateFromTable(rowValues, translationTableWithHeader, 1, 0);
    }

    private static void translateFromTable(Map<String, Object> rowValues, String[][] translationTableWithHeader, int fromColumn, int toColumn) {
        Object valuePresent;
        String toValue;
        String fromKey = translationTableWithHeader[0][fromColumn];
        String toKey = translationTableWithHeader[0][toColumn];
        if (rowValues.get(toKey) == null && (toValue = MapColumnFixture.findToValue(translationTableWithHeader, fromColumn, toColumn, valuePresent = rowValues.get(fromKey))) != null) {
            rowValues.put(toKey, toValue);
        }
    }

    private static String findToValue(String[][] translationTableWithHeader, int fromColumn, int toColumn, Object fromValue) {
        String toValue = null;
        for (int i = 1; i < translationTableWithHeader.length; ++i) {
            String[] row = translationTableWithHeader[i];
            if (!row[fromColumn].equals(fromValue)) continue;
            toValue = row[toColumn];
            break;
        }
        return toValue;
    }

    public void acceptAlternativeInputValuesFromTable(String[][] leftAcceptedForRight) {
        MapColumnFixture.acceptAlternativeInputValuesFromTable(this.getCurrentRowValues(), leftAcceptedForRight);
    }

    public static void acceptAlternativeInputValuesFromTable(Map<String, Object> rowValues, String[][] leftAcceptedForRight) {
        String key = leftAcceptedForRight[0][1];
        Object valuePresent = rowValues.get(key);
        String translation = MapColumnFixture.findToValue(leftAcceptedForRight, 0, 1, valuePresent);
        if (translation != null) {
            rowValues.put(key, translation);
        }
    }

    protected void setDefaults(Map<String, Object> values) {
    }

    public Object get(String columnName) {
        return this.getCurrentRowValues().get(columnName);
    }

    public Map<String, Object> getNested(String columnName) {
        Object value = this.get(columnName);
        if (value == null) {
            throw new IllegalArgumentException("No value for: " + columnName);
        }
        if (!(value instanceof Map)) {
            throw new IllegalArgumentException("Value for: " + columnName + " is not a Map, but a: " + value.getClass());
        }
        return (Map)value;
    }

    protected List<String> getList(String columnName) {
        Object value = this.get(columnName);
        if (value == null) {
            throw new IllegalArgumentException("No value for: " + columnName);
        }
        return Arrays.asList(value.toString().split("\\s*,\\s*"));
    }

    protected Binding createBinding(int column, Parse heads) throws Throwable {
        Object result;
        String header = heads.text();
        if (header.endsWith("=")) {
            result = new ParameterBinding(header.substring(0, header.length() - 1));
        } else if (header.endsWith("?")) {
            result = this.originalCreateBinding(column, heads);
            if (result instanceof Binding.SaveBinding) {
                SaveBinding saveBinding = new SaveBinding();
                saveBinding.adapter = result.adapter;
                result = saveBinding;
            }
        } else if (header.endsWith("?$")) {
            String originalBody = heads.body;
            heads.body = header.substring(0, header.length() - 1);
            result = this.originalCreateBinding(column, heads);
            if (result instanceof Binding.QueryBinding) {
                QueryBinding queryBinding = new QueryBinding();
                ((Binding)queryBinding).adapter = result.adapter;
                result = queryBinding;
            }
            heads.body = originalBody;
        } else {
            return new MapBinding(header);
        }
        return result;
    }

    protected final Binding originalCreateBinding(int column, Parse heads) throws Throwable {
        return super.createBinding(column, heads);
    }

    private String resolveStringWithSymbols(String originalCellText) throws NoSuchSymbolException {
        Matcher m = STRING_WITH_SYMBOL_PATTERN.matcher(originalCellText);
        String newText = null;
        while (m.matches()) {
            String symbolValue = this.getSymbolValue(m.group(3));
            newText = m.group(1) + symbolValue + m.group(5);
            m = STRING_WITH_SYMBOL_PATTERN.matcher(newText);
        }
        return newText;
    }

    private String getSymbolValue(String originalSymbolName) throws NoSuchSymbolException {
        String[] cellContent = null;
        String symbolName = null;
        String newText = null;
        if (originalSymbolName.contains(".")) {
            cellContent = StringUtils.split((String)originalSymbolName, (char)'.');
            symbolName = cellContent[0];
        } else {
            symbolName = originalSymbolName;
        }
        Object symbolValue = Fixture.getSymbol((String)symbolName);
        if (symbolValue instanceof Object[]) {
            int arrayIndex = this.getIndexFromSymbolArray(cellContent);
            newText = (String)this.getSymbolArrayValue(symbolValue, arrayIndex);
        } else if (cellContent != null && cellContent.length == 2) {
            newText = (String)symbolValue;
            MapParameter mapValue = MapParameter.parse(newText);
            if (mapValue != null) {
                newText = mapValue.get(cellContent[1]).toString();
            }
        } else {
            newText = (String)symbolValue;
        }
        if (newText == null) {
            throw new NoSuchSymbolException(String.format("No value for symbol '%s' found.", originalSymbolName));
        }
        return newText;
    }

    private void handleException(Fixture fixture, Parse cell, Exception e) {
        if (cell.text().isEmpty()) {
            cell.addToBody(MapColumnFixture.gray((String)"error"));
        } else {
            fixture.exception(cell, (Throwable)e);
        }
    }

    private String getParameter(String paramKey, String defaultValue) {
        String paramValue = defaultValue;
        if (StringUtils.isNotBlank((CharSequence)paramKey) && this.args != null && this.args.length > 0) {
            for (String arg : this.args) {
                String[] parameter = arg.split("=");
                if (parameter == null || parameter.length != 2 || !paramKey.equals(parameter[0])) continue;
                paramValue = parameter[1];
                break;
            }
        }
        return paramValue;
    }

    public String getArraySeperator() {
        return this.getParameter("ARRAY_SEPARATOR", DEFAULT_ARRAY_SEPARATOR);
    }

    private int getIndexFromSymbolArray(String[] cellContent) {
        int index = Integer.valueOf(cellContent[1]) - 1;
        return index;
    }

    private Object getSymbolArrayValue(Object arraySymbol, int index) {
        Object result = null;
        if (index > -1 && index < ((Object[])arraySymbol).length) {
            result = ((Object[])arraySymbol)[index];
        }
        return result;
    }

    boolean isSpecialBlankValueForFitnesse(String text) {
        if ("".equals(text)) {
            return true;
        }
        if ("blank".equalsIgnoreCase(text)) {
            return true;
        }
        return "null".equalsIgnoreCase(text);
    }

    public Map<String, Object> getCurrentRowValues() {
        return this.currentRowValues;
    }

    private class NoSuchSymbolException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public NoSuchSymbolException(String message) {
            super(message);
        }
    }

    private class QueryBinding
    extends Binding.QueryBinding {
        private QueryBinding() {
        }

        public void doCell(Fixture aFixture, Parse aCell) {
            String originalCellText = aCell.text();
            String newText = null;
            String extraCellText = "";
            try {
                if (!MapColumnFixture.this.isSpecialBlankValueForFitnesse(originalCellText)) {
                    if (originalCellText.startsWith("Array[") && originalCellText.endsWith("]")) {
                        newText = originalCellText.substring(6, originalCellText.length());
                        String separator = MapColumnFixture.this.getArraySeperator();
                        Pattern pattern = Pattern.compile(String.format("\\$(.*?)(%s|])", separator));
                        Matcher matcher = pattern.matcher(newText);
                        while (matcher.find()) {
                            String symbolName = matcher.group();
                            int seperatorLength = matcher.group(2).length();
                            newText = newText.replace(symbolName.substring(0, symbolName.length() - seperatorLength), MapColumnFixture.this.getSymbolValue(symbolName.substring(1, symbolName.length() - seperatorLength)));
                        }
                        newText = newText.substring(0, newText.length() - 1);
                    } else {
                        newText = MapColumnFixture.this.resolveStringWithSymbols(originalCellText);
                        if (newText == null) {
                            newText = MapColumnFixture.this.getSymbolValue(originalCellText);
                        }
                    }
                    aCell.body = newText;
                    extraCellText = String.format(" (%s)", originalCellText);
                }
                super.doCell(aFixture, aCell);
                aCell.addToBody(extraCellText);
            }
            catch (NoSuchSymbolException e) {
                aCell.body = e.getMessage();
                aFixture.wrong(aCell);
            }
        }
    }

    private class MapBinding
    extends Binding {
        private final String header;

        public MapBinding(String headerName) {
            this.header = headerName;
        }

        public void doCell(Fixture aFixture, Parse aCell) throws Throwable {
            String text = aCell.text();
            if ("null".equals(text) || "".equals(text)) {
                text = null;
            } else if ("blank".equals(text)) {
                text = "";
            }
            MapColumnFixture.this.currentRowValues.put(this.header, text);
        }
    }

    public class ParameterBinding
    extends Binding {
        private final String header;

        public ParameterBinding(String headerName) {
            this.header = headerName;
        }

        public void doCell(Fixture fixture, Parse cell) throws Throwable {
            String symbolName = cell.text();
            if (!"".equals(symbolName)) {
                String[] path = symbolName.split("\\.");
                String[] items = symbolName.split("\\s*,\\s*");
                if (items.length > 1 || !Fixture.hasSymbol((String)path[0])) {
                    String result = null;
                    for (String name : items) {
                        String[] nestedPath = name.split("\\.");
                        if (Fixture.hasSymbol((String)nestedPath[0])) {
                            String symbolValue = (String)Fixture.getSymbol((String)nestedPath[0]);
                            if (nestedPath.length > 1) {
                                symbolValue = this.unmarshallParamValue(nestedPath, symbolValue).toString();
                            }
                            if (result == null) {
                                result = symbolValue;
                                cell.addToBody(" = ");
                            } else {
                                result = result + MapColumnFixture.DEFAULT_ARRAY_SEPARATOR + symbolValue;
                                cell.addToBody(", ");
                            }
                            cell.addToBody(this.paramHRef(nestedPath[0], symbolValue));
                            continue;
                        }
                        fixture.exception(cell, (Throwable)new FitFailureException("No such symbol: " + symbolName));
                    }
                    MapColumnFixture.this.getCurrentRowValues().put(this.header, result);
                } else {
                    Object symbol = Fixture.getSymbol((String)path[0]);
                    String valueString = "";
                    Object value = null;
                    if (symbol instanceof String) {
                        valueString = (String)Fixture.getSymbol((String)path[0]);
                        if (!"null".equals(valueString)) {
                            value = this.unmarshallParamValue(path, valueString);
                        }
                    } else if (symbol instanceof Object[]) {
                        if (path.length > 1) {
                            int index = MapColumnFixture.this.getIndexFromSymbolArray(path);
                            value = MapColumnFixture.this.getSymbolArrayValue(symbol, index);
                            valueString = (String)value;
                        } else {
                            value = symbol;
                            valueString = Arrays.toString((Object[])value);
                        }
                    }
                    MapColumnFixture.this.getCurrentRowValues().put(this.header, value);
                    cell.addToBody(" = " + this.paramHRef(symbolName, valueString));
                }
            }
        }

        private String paramHRef(String symbolName, String value) {
            return Fixture.gray((String)("<a href=\"#" + symbolName + "\">" + value + "</a>"));
        }

        private Object unmarshallParamValue(String[] paramNamePath, String valueString) {
            Object value;
            MapParameter mapValue = MapParameter.parse(valueString);
            if (mapValue != null) {
                if (paramNamePath.length == 1) {
                    value = mapValue;
                } else {
                    String nestedKey = paramNamePath[1];
                    value = mapValue.get(nestedKey);
                }
            } else {
                HttpResponse resp = HttpResponse.parse(valueString);
                value = resp != null ? resp : valueString;
            }
            return value;
        }
    }

    protected class SaveBinding
    extends Binding {
        protected SaveBinding() {
        }

        public void doCell(Fixture fixture, Parse cell) {
            try {
                MapColumnFixture.this.executeIfNeeded();
                Object valueObj = this.getValue();
                String symbolValue = String.valueOf(valueObj);
                String symbolName = cell.text();
                if (valueObj instanceof Object[]) {
                    Fixture.setSymbol((String)symbolName, (Object)valueObj);
                    symbolValue = Arrays.toString((Object[])valueObj);
                } else {
                    Fixture.setSymbol((String)symbolName, (Object)symbolValue);
                }
                cell.addToBody(Fixture.gray((String)("<a id=\"" + symbolName + "\"> = " + symbolValue + "</a>")));
            }
            catch (Exception e) {
                MapColumnFixture.this.handleException(fixture, cell, e);
            }
        }

        protected Object getValue() throws Exception {
            return this.adapter.get();
        }
    }
}

