/*
 * Decompiled with CFR 0.152.
 */
package nl.hsac.fitnesse.fixture.fit;

import fit.Binding;
import fit.Parse;
import nl.hsac.fitnesse.fixture.Environment;
import nl.hsac.fitnesse.fixture.fit.MapColumnFixture;
import nl.hsac.fitnesse.fixture.fit.MapParameter;

public class MapDefinitionFixture
extends MapColumnFixture {
    public static final String NR_KEY = "nr";

    @Override
    public void reset() {
        super.reset();
        long nrValue = Environment.getInstance().getNextNr();
        String nr = Long.toString(nrValue);
        if (nr.length() > 10) {
            int origLength = nr.length();
            nr = nr.substring(origLength - 10);
        }
        this.getCurrentRowValues().put(NR_KEY, nr);
    }

    private MapParameter parameter(String headerName) throws Exception {
        this.execute();
        String nr = (String)this.get(NR_KEY);
        MapParameter result = new MapParameter(headerName, nr);
        result.putAll(this.getCurrentRowValues());
        return result;
    }

    @Override
    protected Binding createBinding(int column, Parse heads) throws Throwable {
        String header = heads.text();
        Binding result = header.startsWith("=") ? new SaveMapParameterBinding(header.substring(1, header.length() - 1)) : super.createBinding(column, heads);
        return result;
    }

    private class SaveMapParameterBinding
    extends MapColumnFixture.SaveBinding {
        private final String header;

        public SaveMapParameterBinding(String headerName) {
            this.header = headerName;
        }

        @Override
        protected MapParameter getValue() throws Exception {
            return MapDefinitionFixture.this.parameter(this.header);
        }
    }
}

